/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.enums;

import java.util.Arrays;
import java.util.Optional;

public enum WeatherCondition {
    THUNDERSTORM_LIGHT_RAIN(200, "Thunderstorm", "thunderstorm with light rain", "11"),
    THUNDERSTORM_RAIN(201, "Thunderstorm", "thunderstorm with rain", "11"),
    THUNDERSTORM_HEAVY_RAIN(202, "Thunderstorm", "thunderstorm with heavy rain", "11"),
    THUNDERSTORM_LIGHT(210, "Thunderstorm", "light thunderstorm", "11"),
    THUNDERSTORM(211, "Thunderstorm", "thunderstorm", "11"),
    THUNDERSTORM_HEAVY(212, "Thunderstorm", "heavy thunderstorm", "11"),
    THUNDERSTORM_RAGGED(221, "Thunderstorm", "ragged thunderstorm", "11"),
    THUNDERSTORM_LIGHT_DRIZZLE(230, "Thunderstorm", "thunderstorm with light drizzle", "11"),
    THUNDERSTORM_DRIZZLE(231, "Thunderstorm", "thunderstorm with drizzle", "11"),
    THUNDERSTORM_HEAVY_DRIZZLE(232, "Thunderstorm", "thunderstorm with heavy drizzle", "11"),
    DRIZZLE_LIGHT(300, "Drizzle", "light intensity drizzle", "09"),
    DRIZZLE(301, "Drizzle", "drizzle", "09"),
    DRIZZLE_HEAVY(302, "Drizzle", "heavy intensity drizzle", "09"),
    DRIZZLE_LIGHT_RAIN(310, "Drizzle", "light intensity drizzle rain", "09"),
    DRIZZLE_RAIN(311, "Drizzle", "drizzle rain", "09"),
    DRIZZLE_HEAVY_RAIN(312, "Drizzle", "heavy intensity drizzle rain", "09"),
    DRIZZLE_SHOWER_RAIN(313, "Drizzle", "shower rain and drizzle", "09"),
    DRIZZLE_HEAVY_SHOWER_RAIN(314, "Drizzle", "heavy shower rain and drizzle", "09"),
    DRIZZLE_SHOWER(321, "Drizzle", "shower drizzle", "09"),
    RAIN_LIGHT(500, "Rain", "light rain", "10"),
    RAIN_MODERATE(501, "Rain", "moderate rain", "10"),
    RAIN_HEAVY(502, "Rain", "heavy intensity rain", "10"),
    RAIN_VERY_HEAVY(503, "Rain", "very heavy rain", "10"),
    RAIN_EXTREME(504, "Rain", "very heavy rain", "10"),
    RAIN_FREEZING(511, "Rain", "freezing rain", "10"),
    RAIN_LIGHT_SHOWER(520, "Rain", "light intensity shower rain", "10"),
    RAIN_SHOWER(521, "Rain", "shower rain", "10"),
    RAIN_HEAVY_SHOWER(522, "Rain", "heavy intensity shower rain", "10"),
    RAIN_RAGGED_SHOWER(531, "Rain", "ragged shower rain", "10"),
    SNOW_LIGHT(600, "Snow", "light snow", "13"),
    SNOW(601, "Snow", "snow", "13"),
    SNOW_HEAVY(602, "Snow", "heavy snow", "13"),
    SNOW_SLEET(611, "Snow", "sleet", "13"),
    SNOW_LIGHT_SHOWER_SLEET(612, "Snow", "light shower sleet", "13"),
    SNOW_SHOWER_SLEET(613, "Snow", "shower sleet", "13"),
    SNOW_LIGHT_RAIN_AND_SNOW(615, "Snow", "light rain and snow", "13"),
    SNOW_RAIN_AND_SNOW(616, "Snow", "rain and snow", "13"),
    SNOW_LIGHT_SHOWER_SNOW(620, "Snow", "light shower snow", "13"),
    SNOW_SHOWER_SNOW(621, "Snow", "shower snow", "13"),
    SNOW_HEAVY_SHOWER_SNOW(622, "Snow", "heavy shower snow", "13"),
    MIST(701, "Mist", "mist", "50"),
    SMOKE(711, "Smoke", "smoke", "50"),
    HAZE(721, "Haze", "haze", "50"),
    DUST_WHIRLS(731, "Dust", "sand/dust whirls", "50"),
    FOG(741, "Fog", "fog", "50"),
    SAND(751, "Sand", "sand", "50"),
    DUST(761, "Dust", "dust", "50"),
    ASH(762, "Ash", "volcanic ash", "50"),
    SQUALL(771, "Squall", "squalls", "50"),
    TORNADO(781, "Tornado", "tornado", "50"),
    CLEAR(800, "Clear", "clear sky", "01"),
    CLOUDS_FEW(801, "Clouds", "few clouds: 11-25%", "02"),
    CLOUDS_SCATTERED(802, "Clouds", "scattered clouds: 25-50%", "03"),
    CLOUDS_BROKEN(803, "Clouds", "broken clouds: 51-84%", "04"),
    CLOUDS_OVERCAST(804, "Clouds", "overcast clouds: 85-100%", "04");

    private final int id;
    private final String name;
    private final String description;
    private final String iconId;

    private WeatherCondition(int id, String name, String description, String iconId) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.iconId = iconId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDayIconId() {
        return this.iconId + 'd';
    }

    public String getNightIconId() {
        return this.iconId + 'n';
    }

    public String getDayIconUrl() {
        return WeatherCondition.getIconUrl(this.getDayIconId());
    }

    public String getNightIconUrl() {
        return WeatherCondition.getIconUrl(this.getNightIconId());
    }

    public static String getIconUrl(String iconId) {
        return "http://openweathermap.org/img/w/" + iconId + ".png";
    }

    public static WeatherCondition getById(int id) {
        Optional<WeatherCondition> optionalWeatherCondition = Arrays.stream(WeatherCondition.values()).filter(weatherCondition -> weatherCondition.getId() == id).findFirst();
        return optionalWeatherCondition.orElse(null);
    }

    public String toString() {
        return "Weather condition(" + this.id + "): " + this.name + '(' + this.description + ')';
    }
}

