/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.prominence.openweathermap.api.enums.AirQualityIndex;
import com.github.prominence.openweathermap.api.model.Coordinate;
import com.github.prominence.openweathermap.api.model.air.pollution.AirPollutionDetails;
import com.github.prominence.openweathermap.api.model.air.pollution.AirPollutionRecord;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.TimeZone;

public class AirPollutionResponseMapper {
    public AirPollutionDetails mapToAirPollution(String json) {
        AirPollutionDetails airPollutionDetails;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode root = objectMapper.readTree(json);
            airPollutionDetails = this.mapToAirPollution(root);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot parse Air Pollution response");
        }
        return airPollutionDetails;
    }

    private AirPollutionDetails mapToAirPollution(JsonNode rootNode) {
        AirPollutionDetails airPollutionDetails = new AirPollutionDetails();
        airPollutionDetails.setCoordinate(this.parseCoordinate(rootNode.get("coord")));
        ArrayList<AirPollutionRecord> sampleList = new ArrayList<AirPollutionRecord>();
        JsonNode sampleListNode = rootNode.get("list");
        sampleListNode.forEach(sampleNode -> sampleList.add(this.parseAirPollutionSample((JsonNode)sampleNode)));
        airPollutionDetails.setAirPollutionRecords(sampleList);
        return airPollutionDetails;
    }

    private AirPollutionRecord parseAirPollutionSample(JsonNode sampleNode) {
        AirPollutionRecord airPollutionRecord = new AirPollutionRecord();
        airPollutionRecord.setForecastTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(sampleNode.get("dt").asInt()), TimeZone.getDefault().toZoneId()));
        airPollutionRecord.setAirQualityIndex(AirQualityIndex.getByIndex(sampleNode.get("main").get("aqi").asInt()));
        JsonNode componentsNode = sampleNode.get("components");
        airPollutionRecord.setCO(componentsNode.get("co").asDouble());
        airPollutionRecord.setNO(componentsNode.get("no").asDouble());
        airPollutionRecord.setNO2(componentsNode.get("no2").asDouble());
        airPollutionRecord.setO3(componentsNode.get("o3").asDouble());
        airPollutionRecord.setSO2(componentsNode.get("so2").asDouble());
        airPollutionRecord.setPM2_5(componentsNode.get("pm2_5").asDouble());
        airPollutionRecord.setPM10(componentsNode.get("pm10").asDouble());
        airPollutionRecord.setNH3(componentsNode.get("nh3").asDouble());
        return airPollutionRecord;
    }

    private Coordinate parseCoordinate(JsonNode rootNode) {
        JsonNode latitudeNode = rootNode.get("lat");
        JsonNode longitudeNode = rootNode.get("lon");
        if (latitudeNode != null && longitudeNode != null) {
            return Coordinate.of(latitudeNode.asDouble(), longitudeNode.asDouble());
        }
        return null;
    }
}

