/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.prominence.openweathermap.api.enums.UnitSystem;
import com.github.prominence.openweathermap.api.model.AtmosphericPressure;
import com.github.prominence.openweathermap.api.model.Clouds;
import com.github.prominence.openweathermap.api.model.Coordinate;
import com.github.prominence.openweathermap.api.model.Humidity;
import com.github.prominence.openweathermap.api.model.Temperature;
import com.github.prominence.openweathermap.api.model.WeatherState;
import com.github.prominence.openweathermap.api.model.weather.Location;
import com.github.prominence.openweathermap.api.model.weather.Rain;
import com.github.prominence.openweathermap.api.model.weather.Snow;
import com.github.prominence.openweathermap.api.model.weather.Weather;
import com.github.prominence.openweathermap.api.model.weather.Wind;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class CurrentWeatherResponseMapper {
    private final UnitSystem unitSystem;

    public CurrentWeatherResponseMapper(UnitSystem unitSystem) {
        this.unitSystem = unitSystem != null ? unitSystem : UnitSystem.STANDARD;
    }

    public Weather getSingle(String json) {
        Weather weather;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode root = objectMapper.readTree(json);
            weather = this.getSingle(root);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot parse Weather response");
        }
        return weather;
    }

    private Weather getSingle(JsonNode rootNode) {
        JsonNode weatherArrayNode = rootNode.get("weather");
        JsonNode weatherNode = weatherArrayNode != null ? weatherArrayNode.get(0) : null;
        Weather weather = new Weather();
        weather.setWeatherState(this.parseWeatherState(weatherNode));
        weather.setTemperature(this.parseTemperature(rootNode));
        weather.setAtmosphericPressure(this.parsePressure(rootNode));
        weather.setHumidity(this.parseHumidity(rootNode));
        weather.setWind(this.parseWind(rootNode));
        weather.setRain(this.parseRain(rootNode));
        weather.setSnow(this.parseSnow(rootNode));
        weather.setClouds(this.parseClouds(rootNode));
        weather.setLocation(this.parseLocation(rootNode));
        JsonNode dtNode = rootNode.get("dt");
        if (dtNode != null) {
            weather.setCalculationTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(dtNode.asInt()), TimeZone.getDefault().toZoneId()));
        }
        return weather;
    }

    public List<Weather> getList(String json) {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<Weather> weatherList = new ArrayList<Weather>();
        try {
            JsonNode root = objectMapper.readTree(json);
            JsonNode listNode = root.get("list");
            listNode.forEach(jsonNode -> weatherList.add(this.getSingle((JsonNode)jsonNode)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot parse Weather response");
        }
        return weatherList;
    }

    private WeatherState parseWeatherState(JsonNode weatherNode) {
        if (weatherNode == null) {
            return null;
        }
        WeatherState weatherState = new WeatherState(weatherNode.get("id").asInt(), weatherNode.get("main").asText(), weatherNode.get("description").asText());
        weatherState.setIconId(weatherNode.get("icon").asText());
        return weatherState;
    }

    private Temperature parseTemperature(JsonNode rootNode) {
        JsonNode tempMinNode;
        JsonNode tempMaxNode;
        JsonNode mainNode = rootNode.get("main");
        double tempValue = mainNode.get("temp").asDouble();
        Temperature temperature = Temperature.withValue(tempValue, this.unitSystem.getTemperatureUnit());
        JsonNode feelsLikeNode = mainNode.get("feels_like");
        if (feelsLikeNode != null) {
            temperature.setFeelsLike(feelsLikeNode.asDouble());
        }
        if ((tempMaxNode = mainNode.get("temp_max")) != null) {
            temperature.setMaxTemperature(tempMaxNode.asDouble());
        }
        if ((tempMinNode = mainNode.get("temp_min")) != null) {
            temperature.setMinTemperature(tempMinNode.asDouble());
        }
        return temperature;
    }

    private AtmosphericPressure parsePressure(JsonNode rootNode) {
        JsonNode mainNode = rootNode.get("main");
        AtmosphericPressure atmosphericPressure = AtmosphericPressure.withValue(mainNode.get("pressure").asDouble());
        JsonNode seaLevelNode = mainNode.get("sea_level");
        JsonNode groundLevelNode = mainNode.get("grnd_level");
        if (seaLevelNode != null) {
            atmosphericPressure.setSeaLevelValue(seaLevelNode.asDouble());
        }
        if (groundLevelNode != null) {
            atmosphericPressure.setGroundLevelValue(groundLevelNode.asDouble());
        }
        return atmosphericPressure;
    }

    private Humidity parseHumidity(JsonNode rootNode) {
        JsonNode mainNode = rootNode.get("main");
        return Humidity.withValue((byte)mainNode.get("humidity").asInt());
    }

    private Wind parseWind(JsonNode rootNode) {
        JsonNode gustNode;
        JsonNode windNode = rootNode.get("wind");
        double speed = windNode.get("speed").asDouble();
        Wind wind = Wind.withValue(speed, this.unitSystem.getWindUnit());
        JsonNode degNode = windNode.get("deg");
        if (degNode != null) {
            wind.setDegrees(degNode.asDouble());
        }
        if ((gustNode = windNode.get("gust")) != null) {
            wind.setGust(gustNode.asDouble());
        }
        return wind;
    }

    private Rain parseRain(JsonNode rootNode) {
        JsonNode rainNode = rootNode.get("rain");
        if (rainNode != null) {
            JsonNode oneHourNode = rainNode.get("1h");
            JsonNode threeHourNode = rainNode.get("3h");
            if (oneHourNode != null && threeHourNode != null) {
                return Rain.withValues(oneHourNode.asDouble(), threeHourNode.asDouble());
            }
            if (oneHourNode != null) {
                return Rain.withOneHourLevelValue(oneHourNode.asDouble());
            }
            if (threeHourNode != null) {
                return Rain.withThreeHourLevelValue(threeHourNode.asDouble());
            }
        }
        return null;
    }

    private Snow parseSnow(JsonNode rootNode) {
        JsonNode snowNode = rootNode.get("snow");
        if (snowNode != null) {
            JsonNode oneHourNode = snowNode.get("1h");
            JsonNode threeHourNode = snowNode.get("3h");
            if (oneHourNode != null && threeHourNode != null) {
                return Snow.withValues(oneHourNode.asDouble(), threeHourNode.asDouble());
            }
            if (oneHourNode != null) {
                return Snow.withOneHourLevelValue(oneHourNode.asDouble());
            }
            if (threeHourNode != null) {
                return Snow.withThreeHourLevelValue(threeHourNode.asDouble());
            }
        }
        return null;
    }

    private Clouds parseClouds(JsonNode rootNode) {
        JsonNode cloudsNode = rootNode.get("clouds");
        JsonNode allValueNode = cloudsNode.get("all");
        if (allValueNode != null) {
            return Clouds.withValue((byte)allValueNode.asInt());
        }
        return null;
    }

    private Location parseLocation(JsonNode rootNode) {
        JsonNode coordNode;
        JsonNode sysNode;
        Location location = Location.withValues(rootNode.get("id").asInt(), rootNode.get("name").asText());
        JsonNode timezoneNode = rootNode.get("timezone");
        if (timezoneNode != null) {
            location.setZoneOffset(ZoneOffset.ofTotalSeconds(timezoneNode.asInt()));
        }
        if ((sysNode = rootNode.get("sys")) != null) {
            JsonNode countryNode = sysNode.get("country");
            if (countryNode != null) {
                location.setCountryCode(countryNode.asText());
            }
            JsonNode sunriseNode = sysNode.get("sunrise");
            JsonNode sunsetNode = sysNode.get("sunset");
            if (sunriseNode != null) {
                location.setSunriseTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(sunriseNode.asInt()), TimeZone.getDefault().toZoneId()));
            }
            if (sunsetNode != null) {
                location.setSunsetTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(sunsetNode.asInt()), TimeZone.getDefault().toZoneId()));
            }
        }
        if ((coordNode = rootNode.get("coord")) != null) {
            location.setCoordinate(this.parseCoordinate(coordNode));
        }
        return location;
    }

    private Coordinate parseCoordinate(JsonNode rootNode) {
        JsonNode latitudeNode = rootNode.get("lat");
        JsonNode longitudeNode = rootNode.get("lon");
        if (latitudeNode != null && longitudeNode != null) {
            return Coordinate.of(latitudeNode.asDouble(), longitudeNode.asDouble());
        }
        return null;
    }
}

