/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.prominence.openweathermap.api.enums.UnitSystem;
import com.github.prominence.openweathermap.api.model.AtmosphericPressure;
import com.github.prominence.openweathermap.api.model.Clouds;
import com.github.prominence.openweathermap.api.model.Coordinate;
import com.github.prominence.openweathermap.api.model.DayTime;
import com.github.prominence.openweathermap.api.model.Humidity;
import com.github.prominence.openweathermap.api.model.Temperature;
import com.github.prominence.openweathermap.api.model.WeatherState;
import com.github.prominence.openweathermap.api.model.forecast.Forecast;
import com.github.prominence.openweathermap.api.model.forecast.Location;
import com.github.prominence.openweathermap.api.model.forecast.Rain;
import com.github.prominence.openweathermap.api.model.forecast.Snow;
import com.github.prominence.openweathermap.api.model.forecast.WeatherForecast;
import com.github.prominence.openweathermap.api.model.forecast.Wind;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.TimeZone;

public class FiveDayThreeHourStepForecastResponseMapper {
    private final UnitSystem unitSystem;

    public FiveDayThreeHourStepForecastResponseMapper(UnitSystem unitSystem) {
        this.unitSystem = unitSystem;
    }

    public Forecast mapToForecast(String json) {
        Forecast forecast;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode root = objectMapper.readTree(json);
            forecast = this.mapToForecast(root);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot parse Forecast response");
        }
        return forecast;
    }

    private Forecast mapToForecast(JsonNode root) {
        Forecast forecast = new Forecast();
        forecast.setLocation(this.parseLocation(root.get("city")));
        ArrayList<WeatherForecast> forecasts = new ArrayList<WeatherForecast>(root.get("cnt").asInt());
        JsonNode forecastListNode = root.get("list");
        forecastListNode.forEach(forecastNode -> forecasts.add(this.parseWeatherForecast((JsonNode)forecastNode)));
        forecast.setWeatherForecasts(forecasts);
        return forecast;
    }

    private WeatherForecast parseWeatherForecast(JsonNode rootNode) {
        WeatherForecast weatherForecast = new WeatherForecast();
        JsonNode weatherArrayNode = rootNode.get("weather");
        if (weatherArrayNode != null) {
            JsonNode weatherNode = weatherArrayNode.get(0);
            weatherForecast.setWeatherState(this.parseWeatherState(weatherNode));
        }
        JsonNode mainNode = rootNode.get("main");
        weatherForecast.setTemperature(this.parseTemperature(mainNode));
        weatherForecast.setAtmosphericPressure(this.parsePressure(mainNode));
        weatherForecast.setHumidity(this.parseHumidity(mainNode));
        weatherForecast.setClouds(this.parseClouds(rootNode));
        weatherForecast.setWind(this.parseWind(rootNode));
        weatherForecast.setRain(this.parseRain(rootNode));
        weatherForecast.setSnow(this.parseSnow(rootNode));
        JsonNode sysNode = rootNode.get("sys");
        if (sysNode != null) {
            weatherForecast.setDayTime("d".equals(sysNode.get("pod").asText()) ? DayTime.DAY : DayTime.NIGHT);
        }
        weatherForecast.setForecastTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(rootNode.get("dt").asLong()), TimeZone.getDefault().toZoneId()));
        weatherForecast.setForecastTimeISO(rootNode.get("dt_txt").asText());
        return weatherForecast;
    }

    private WeatherState parseWeatherState(JsonNode weatherNode) {
        if (weatherNode == null) {
            return null;
        }
        WeatherState weatherState = new WeatherState(weatherNode.get("id").asInt(), weatherNode.get("main").asText(), weatherNode.get("description").asText());
        weatherState.setIconId(weatherNode.get("icon").asText());
        return weatherState;
    }

    private Temperature parseTemperature(JsonNode rootNode) {
        JsonNode tempFeelsLike;
        JsonNode tempMinNode;
        double tempValue = rootNode.get("temp").asDouble();
        Temperature temperature = Temperature.withValue(tempValue, this.unitSystem.getTemperatureUnit());
        JsonNode tempMaxNode = rootNode.get("temp_max");
        if (tempMaxNode != null) {
            temperature.setMaxTemperature(tempMaxNode.asDouble());
        }
        if ((tempMinNode = rootNode.get("temp_min")) != null) {
            temperature.setMinTemperature(tempMinNode.asDouble());
        }
        if ((tempFeelsLike = rootNode.get("feels_like")) != null) {
            temperature.setFeelsLike(tempFeelsLike.asDouble());
        }
        return temperature;
    }

    private AtmosphericPressure parsePressure(JsonNode rootNode) {
        AtmosphericPressure atmosphericPressure = AtmosphericPressure.withValue(rootNode.get("pressure").asDouble());
        JsonNode seaLevelNode = rootNode.get("sea_level");
        JsonNode groundLevelNode = rootNode.get("grnd_level");
        if (seaLevelNode != null) {
            atmosphericPressure.setSeaLevelValue(seaLevelNode.asDouble());
        }
        if (groundLevelNode != null) {
            atmosphericPressure.setGroundLevelValue(groundLevelNode.asDouble());
        }
        return atmosphericPressure;
    }

    private Humidity parseHumidity(JsonNode rootNode) {
        return Humidity.withValue((byte)rootNode.get("humidity").asInt());
    }

    private Wind parseWind(JsonNode root) {
        JsonNode windNode = root.get("wind");
        double speed = windNode.get("speed").asDouble();
        Wind wind = Wind.withValue(speed, this.unitSystem.getWindUnit());
        JsonNode degNode = windNode.get("deg");
        if (degNode != null) {
            wind.setDegrees(degNode.asDouble());
        }
        return wind;
    }

    private Rain parseRain(JsonNode root) {
        JsonNode threeHourNode;
        JsonNode rainNode = root.get("rain");
        if (rainNode != null && (threeHourNode = rainNode.get("3h")) != null) {
            return Rain.withThreeHourLevelValue(threeHourNode.asDouble());
        }
        return null;
    }

    private Snow parseSnow(JsonNode root) {
        JsonNode threeHourNode;
        JsonNode snowNode = root.get("snow");
        if (snowNode != null && (threeHourNode = snowNode.get("3h")) != null) {
            return Snow.withThreeHourLevelValue(threeHourNode.asDouble());
        }
        return null;
    }

    private Clouds parseClouds(JsonNode rootNode) {
        JsonNode cloudsNode = rootNode.get("clouds");
        JsonNode allValueNode = cloudsNode.get("all");
        if (allValueNode != null) {
            return Clouds.withValue((byte)allValueNode.asInt());
        }
        return null;
    }

    private Location parseLocation(JsonNode rootNode) {
        JsonNode populationNode;
        JsonNode coordNode;
        JsonNode countryNode;
        Location location = Location.withValues(rootNode.get("id").asInt(), rootNode.get("name").asText());
        JsonNode timezoneNode = rootNode.get("timezone");
        if (timezoneNode != null) {
            location.setZoneOffset(ZoneOffset.ofTotalSeconds(timezoneNode.asInt()));
        }
        if ((countryNode = rootNode.get("country")) != null) {
            location.setCountryCode(countryNode.asText());
        }
        JsonNode sunriseNode = rootNode.get("sunrise");
        JsonNode sunsetNode = rootNode.get("sunset");
        if (sunriseNode != null) {
            location.setSunriseTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(sunriseNode.asLong()), TimeZone.getDefault().toZoneId()));
        }
        if (sunsetNode != null) {
            location.setSunsetTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(sunsetNode.asLong()), TimeZone.getDefault().toZoneId()));
        }
        if ((coordNode = rootNode.get("coord")) != null) {
            location.setCoordinate(this.parseCoordinate(coordNode));
        }
        if ((populationNode = rootNode.get("population")) != null) {
            location.setPopulation(populationNode.asLong());
        }
        return location;
    }

    private Coordinate parseCoordinate(JsonNode rootNode) {
        JsonNode latitudeNode = rootNode.get("lat");
        JsonNode longitudeNode = rootNode.get("lon");
        if (latitudeNode != null && longitudeNode != null) {
            return Coordinate.of(latitudeNode.asDouble(), longitudeNode.asDouble());
        }
        return null;
    }
}

