/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.prominence.openweathermap.api.enums.UnitSystem;
import com.github.prominence.openweathermap.api.model.Clouds;
import com.github.prominence.openweathermap.api.model.Coordinate;
import com.github.prominence.openweathermap.api.model.Humidity;
import com.github.prominence.openweathermap.api.model.WeatherState;
import com.github.prominence.openweathermap.api.model.onecall.AtmosphericPressure;
import com.github.prominence.openweathermap.api.model.onecall.Current;
import com.github.prominence.openweathermap.api.model.onecall.Rain;
import com.github.prominence.openweathermap.api.model.onecall.Snow;
import com.github.prominence.openweathermap.api.model.onecall.Temperature;
import com.github.prominence.openweathermap.api.model.onecall.Wind;
import com.github.prominence.openweathermap.api.model.onecall.current.Alert;
import com.github.prominence.openweathermap.api.model.onecall.current.CurrentWeatherData;
import com.github.prominence.openweathermap.api.model.onecall.current.Daily;
import com.github.prominence.openweathermap.api.model.onecall.current.DailyRain;
import com.github.prominence.openweathermap.api.model.onecall.current.DailySnow;
import com.github.prominence.openweathermap.api.model.onecall.current.DailyTemperature;
import com.github.prominence.openweathermap.api.model.onecall.current.Hourly;
import com.github.prominence.openweathermap.api.model.onecall.current.Minutely;
import com.github.prominence.openweathermap.api.model.onecall.current.MoonPhase;
import com.github.prominence.openweathermap.api.model.onecall.historical.HistoricalWeather;
import com.github.prominence.openweathermap.api.model.onecall.historical.HistoricalWeatherData;
import com.github.prominence.openweathermap.api.model.onecall.historical.HourlyHistorical;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class OneCallWeatherResponseMapper {
    private final UnitSystem unitSystem;

    public OneCallWeatherResponseMapper(UnitSystem unitSystem) {
        this.unitSystem = unitSystem;
    }

    public CurrentWeatherData mapToCurrent(String json) {
        CurrentWeatherData currentData;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode root = objectMapper.readTree(json);
            currentData = this.mapToCurrent(root);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot parse OneCall response");
        }
        return currentData;
    }

    public HistoricalWeatherData mapToHistorical(String json) {
        HistoricalWeatherData historicalData;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode root = objectMapper.readTree(json);
            historicalData = this.mapToHistorical(root);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot parse OneCall response");
        }
        return historicalData;
    }

    private CurrentWeatherData mapToCurrent(JsonNode rootNode) {
        CurrentWeatherData currentData = new CurrentWeatherData();
        currentData.setCoordinate(Coordinate.of(rootNode.get("lat").asDouble(), rootNode.get("lon").asDouble()));
        currentData.setTimezone(ZoneId.of(rootNode.get("timezone").asText()));
        currentData.setTimezoneOffset(ZoneOffset.ofTotalSeconds(rootNode.get("timezone_offset").asInt()));
        currentData.setCurrent(this.parseCurrent(rootNode.get("current")));
        currentData.setMinutelyList(this.parseMinutelyList(rootNode.get("minutely")));
        currentData.setHourlyList(this.parseHourlyList(rootNode.get("hourly")));
        currentData.setDailyList(this.parseDailyList(rootNode.get("daily")));
        currentData.setAlerts(this.parseAlerts(rootNode.get("alerts")));
        return currentData;
    }

    private Current parseCurrent(JsonNode currentNode) {
        if (currentNode == null) {
            return null;
        }
        Current current = new Current();
        current.setForecastTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(currentNode.get("dt").asInt()), TimeZone.getDefault().toZoneId()));
        current.setSunriseTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(currentNode.get("sunrise").asInt()), TimeZone.getDefault().toZoneId()));
        current.setSunsetTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(currentNode.get("sunset").asInt()), TimeZone.getDefault().toZoneId()));
        current.setWeatherState(this.parseWeatherState(currentNode.get("weather").get(0)));
        current.setTemperature(this.parseTemperature(currentNode));
        current.setAtmosphericPressure(this.parsePressure(currentNode));
        current.setHumidity(this.parseHumidity(currentNode));
        current.setClouds(this.parseClouds(currentNode));
        current.setUvIndex(currentNode.get("uvi").asDouble());
        JsonNode visibilityNode = currentNode.get("visibility");
        if (visibilityNode != null) {
            current.setVisibilityInMetres(visibilityNode.asDouble());
        }
        current.setWind(this.parseWind(currentNode));
        current.setRain(this.parseRain(currentNode));
        current.setSnow(this.parseSnow(currentNode));
        return current;
    }

    private List<Minutely> parseMinutelyList(JsonNode minutelyListNode) {
        if (minutelyListNode == null) {
            return null;
        }
        ArrayList<Minutely> minutelyList = new ArrayList<Minutely>();
        for (JsonNode minutelyNode : minutelyListNode) {
            minutelyList.add(Minutely.withValue(LocalDateTime.ofInstant(Instant.ofEpochSecond(minutelyNode.get("dt").asInt()), TimeZone.getDefault().toZoneId()), minutelyNode.get("precipitation").asDouble()));
        }
        return minutelyList;
    }

    private List<Hourly> parseHourlyList(JsonNode hourlyListNode) {
        if (hourlyListNode == null) {
            return null;
        }
        ArrayList<Hourly> hourlyList = new ArrayList<Hourly>();
        for (JsonNode hourlyNode : hourlyListNode) {
            JsonNode visibilityNode;
            Hourly hourly = new Hourly();
            hourly.setForecastTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(hourlyNode.get("dt").asInt()), TimeZone.getDefault().toZoneId()));
            hourly.setWeatherState(this.parseWeatherState(hourlyNode.get("weather").get(0)));
            hourly.setTemperature(this.parseTemperature(hourlyNode));
            hourly.setAtmosphericPressure(this.parsePressure(hourlyNode));
            hourly.setHumidity(this.parseHumidity(hourlyNode));
            hourly.setClouds(this.parseClouds(hourlyNode));
            JsonNode uviNode = hourlyNode.get("uvi");
            if (uviNode != null) {
                hourly.setUvIndex(uviNode.asDouble());
            }
            if ((visibilityNode = hourlyNode.get("visibility")) != null) {
                hourly.setVisibilityInMetres(visibilityNode.asDouble());
            }
            hourly.setWind(this.parseWind(hourlyNode));
            JsonNode popNode = hourlyNode.get("pop");
            if (popNode != null) {
                hourly.setProbabilityOfPrecipitation(popNode.asDouble());
            }
            hourly.setRain(this.parseRain(hourlyNode));
            hourly.setSnow(this.parseSnow(hourlyNode));
            hourlyList.add(hourly);
        }
        return hourlyList;
    }

    private List<Daily> parseDailyList(JsonNode dailyListNode) {
        if (dailyListNode == null) {
            return null;
        }
        ArrayList<Daily> dailyList = new ArrayList<Daily>();
        for (JsonNode dailyNode : dailyListNode) {
            JsonNode moonPhaseNode;
            JsonNode moonsetTimeNode;
            Daily daily = new Daily();
            daily.setForecastTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(dailyNode.get("dt").asInt()), TimeZone.getDefault().toZoneId()));
            daily.setSunriseTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(dailyNode.get("sunrise").asInt()), TimeZone.getDefault().toZoneId()));
            daily.setSunsetTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(dailyNode.get("sunset").asInt()), TimeZone.getDefault().toZoneId()));
            JsonNode moonriseTimeNode = dailyNode.get("moonrise");
            if (moonriseTimeNode != null) {
                daily.setMoonriseTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(moonriseTimeNode.asInt()), TimeZone.getDefault().toZoneId()));
            }
            if ((moonsetTimeNode = dailyNode.get("moonset")) != null) {
                daily.setMoonsetTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(moonsetTimeNode.asInt()), TimeZone.getDefault().toZoneId()));
            }
            if ((moonPhaseNode = dailyNode.get("moon_phase")) != null) {
                daily.setMoonPhase(new MoonPhase(moonPhaseNode.asDouble()));
            }
            daily.setWeatherState(this.parseWeatherState(dailyNode.get("weather").get(0)));
            daily.setTemperature(this.parseDailyTemperature(dailyNode));
            daily.setAtmosphericPressure(this.parsePressure(dailyNode));
            daily.setHumidity(this.parseHumidity(dailyNode));
            daily.setWind(this.parseWind(dailyNode));
            daily.setClouds(this.parseClouds(dailyNode));
            daily.setUvIndex(dailyNode.get("uvi").asDouble());
            daily.setProbabilityOfPrecipitation(dailyNode.get("pop").asDouble());
            daily.setRain(this.parseDailyRain(dailyNode));
            daily.setSnow(this.parseDailySnow(dailyNode));
            dailyList.add(daily);
        }
        return dailyList;
    }

    private List<Alert> parseAlerts(JsonNode alertsNode) {
        if (alertsNode == null) {
            return null;
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        for (JsonNode alertNode : alertsNode) {
            Alert alert = new Alert();
            alert.setSenderName(alertNode.get("sender_name").asText());
            alert.setEventName(alertNode.get("event").asText());
            alert.setStartTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(alertNode.get("start").asInt()), TimeZone.getDefault().toZoneId()));
            alert.setEndTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(alertNode.get("end").asInt()), TimeZone.getDefault().toZoneId()));
            alert.setDescription(alertNode.get("description").asText());
            alerts.add(alert);
        }
        return alerts;
    }

    private HistoricalWeatherData mapToHistorical(JsonNode rootNode) {
        HistoricalWeatherData historicalData = new HistoricalWeatherData();
        historicalData.setCoordinate(Coordinate.of(rootNode.get("lat").asDouble(), rootNode.get("lon").asDouble()));
        historicalData.setTimezone(ZoneId.of(rootNode.get("timezone").asText()));
        historicalData.setTimezoneOffset(ZoneOffset.ofTotalSeconds(rootNode.get("timezone_offset").asInt()));
        historicalData.setHistoricalWeather(this.parseHistoricalWeather(rootNode.get("current")));
        historicalData.setHourlyList(this.parseHourlyHistoricalList(rootNode.get("hourly")));
        return historicalData;
    }

    private HistoricalWeather parseHistoricalWeather(JsonNode currentNode) {
        if (currentNode == null) {
            return null;
        }
        HistoricalWeather historicalWeather = new HistoricalWeather();
        historicalWeather.setForecastTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(currentNode.get("dt").asInt()), TimeZone.getDefault().toZoneId()));
        historicalWeather.setSunriseTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(currentNode.get("sunrise").asInt()), TimeZone.getDefault().toZoneId()));
        historicalWeather.setSunsetTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(currentNode.get("sunset").asInt()), TimeZone.getDefault().toZoneId()));
        JsonNode weatherListNode = currentNode.get("weather");
        if (weatherListNode != null) {
            historicalWeather.setWeatherState(this.parseWeatherState(weatherListNode.get(0)));
        }
        historicalWeather.setTemperature(this.parseTemperature(currentNode));
        historicalWeather.setAtmosphericPressure(this.parsePressure(currentNode));
        historicalWeather.setHumidity(this.parseHumidity(currentNode));
        historicalWeather.setClouds(this.parseClouds(currentNode));
        historicalWeather.setUvIndex(currentNode.get("uvi").asDouble());
        JsonNode visibilityMode = currentNode.get("visibility");
        if (visibilityMode != null) {
            historicalWeather.setVisibilityInMetres(visibilityMode.asDouble());
        }
        historicalWeather.setWind(this.parseWind(currentNode));
        historicalWeather.setRain(this.parseRain(currentNode));
        historicalWeather.setSnow(this.parseSnow(currentNode));
        return historicalWeather;
    }

    private List<HourlyHistorical> parseHourlyHistoricalList(JsonNode hourlyListNode) {
        if (hourlyListNode == null) {
            return null;
        }
        ArrayList<HourlyHistorical> hourlyList = new ArrayList<HourlyHistorical>();
        for (JsonNode hourlyNode : hourlyListNode) {
            HourlyHistorical hourly = new HourlyHistorical();
            hourly.setForecastTime(LocalDateTime.ofInstant(Instant.ofEpochSecond(hourlyNode.get("dt").asInt()), TimeZone.getDefault().toZoneId()));
            hourly.setWeatherState(this.parseWeatherState(hourlyNode.get("weather").get(0)));
            hourly.setTemperature(this.parseTemperature(hourlyNode));
            hourly.setAtmosphericPressure(this.parsePressure(hourlyNode));
            hourly.setHumidity(this.parseHumidity(hourlyNode));
            hourly.setClouds(this.parseClouds(hourlyNode));
            JsonNode visibilityNode = hourlyNode.get("visibility");
            if (visibilityNode != null) {
                hourly.setVisibilityInMetres(visibilityNode.asDouble());
            }
            hourly.setWind(this.parseWind(hourlyNode));
            hourly.setRain(this.parseRain(hourlyNode));
            hourly.setSnow(this.parseSnow(hourlyNode));
            hourlyList.add(hourly);
        }
        return hourlyList;
    }

    private WeatherState parseWeatherState(JsonNode weatherNode) {
        if (weatherNode == null) {
            return null;
        }
        WeatherState weatherState = new WeatherState(weatherNode.get("id").asInt(), weatherNode.get("main").asText(), weatherNode.get("description").asText());
        weatherState.setIconId(weatherNode.get("icon").asText());
        return weatherState;
    }

    private Temperature parseTemperature(JsonNode rootNode) {
        JsonNode dewPoint;
        double tempValue = rootNode.get("temp").asDouble();
        Temperature temperature = Temperature.withValue(tempValue, this.unitSystem.getTemperatureUnit());
        JsonNode tempFeelsLike = rootNode.get("feels_like");
        if (tempFeelsLike != null) {
            temperature.setFeelsLike(tempFeelsLike.asDouble());
        }
        if ((dewPoint = rootNode.get("dew_point")) != null) {
            temperature.setDewPoint(dewPoint.asDouble());
        }
        return temperature;
    }

    private DailyTemperature parseDailyTemperature(JsonNode dailyNode) {
        DailyTemperature temperature = new DailyTemperature();
        JsonNode tempNode = dailyNode.get("temp");
        temperature.setMorning(tempNode.get("morn").asDouble());
        temperature.setDay(tempNode.get("day").asDouble());
        temperature.setEve(tempNode.get("eve").asDouble());
        temperature.setNight(tempNode.get("night").asDouble());
        temperature.setMin(tempNode.get("min").asDouble());
        temperature.setMax(tempNode.get("max").asDouble());
        JsonNode feelsLikeNode = dailyNode.get("feels_like");
        temperature.setMorningFeelsLike(feelsLikeNode.get("morn").asDouble());
        temperature.setDayFeelsLike(feelsLikeNode.get("day").asDouble());
        temperature.setEveFeelsLike(feelsLikeNode.get("eve").asDouble());
        temperature.setNightFeelsLike(feelsLikeNode.get("night").asDouble());
        return temperature;
    }

    private AtmosphericPressure parsePressure(JsonNode rootNode) {
        return AtmosphericPressure.withValue(rootNode.get("pressure").asDouble());
    }

    private Humidity parseHumidity(JsonNode rootNode) {
        return Humidity.withValue((byte)rootNode.get("humidity").asInt());
    }

    private Wind parseWind(JsonNode rootNode) {
        JsonNode gustNode;
        JsonNode windSpeedNode = rootNode.get("wind_speed");
        if (windSpeedNode == null) {
            return null;
        }
        Wind wind = Wind.withValue(windSpeedNode.asDouble(), this.unitSystem.getWindUnit());
        JsonNode degNode = rootNode.get("wind_deg");
        if (degNode != null) {
            wind.setDegrees(degNode.asDouble());
        }
        if ((gustNode = rootNode.get("wind_gust")) != null) {
            wind.setGust(gustNode.asDouble());
        }
        return wind;
    }

    private Rain parseRain(JsonNode root) {
        JsonNode oneHourNode;
        JsonNode rainNode = root.get("rain");
        if (rainNode != null && (oneHourNode = rainNode.get("1h")) != null) {
            return Rain.withOneHourLevelValue(oneHourNode.asDouble());
        }
        return null;
    }

    private DailyRain parseDailyRain(JsonNode dailyNode) {
        JsonNode valueNode = dailyNode.get("rain");
        if (valueNode != null) {
            return DailyRain.withValue(valueNode.asDouble());
        }
        return null;
    }

    private Snow parseSnow(JsonNode root) {
        JsonNode OneHourNode;
        JsonNode snowNode = root.get("snow");
        if (snowNode != null && (OneHourNode = snowNode.get("1h")) != null) {
            Rain.withOneHourLevelValue(OneHourNode.asDouble());
        }
        return null;
    }

    private DailySnow parseDailySnow(JsonNode dailyNode) {
        JsonNode valueNode = dailyNode.get("snow");
        if (valueNode != null) {
            return DailySnow.withValue(valueNode.asDouble());
        }
        return null;
    }

    private Clouds parseClouds(JsonNode rootNode) {
        JsonNode cloudsNode = rootNode.get("clouds");
        if (cloudsNode != null) {
            return Clouds.withValue((byte)cloudsNode.asInt());
        }
        return null;
    }
}

