/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model;

import java.util.Objects;

public class AtmosphericPressure {
    private static final String DEFAULT_UNIT = "hPa";
    private double value;
    private Double seaLevelValue;
    private Double groundLevelValue;

    private AtmosphericPressure(double value) {
        this.value = value;
    }

    public static AtmosphericPressure withValue(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Atmospheric pressure value must be in [0, +\u221e) range.");
        }
        return new AtmosphericPressure(value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Atmospheric pressure value must be in [0, +\u221e) range.");
        }
        this.value = value;
    }

    public Double getSeaLevelValue() {
        return this.seaLevelValue;
    }

    public void setSeaLevelValue(double seaLevelValue) {
        if (seaLevelValue < 0.0) {
            throw new IllegalArgumentException("Atmospheric pressure value must be in [0, +\u221e) range.");
        }
        this.seaLevelValue = seaLevelValue;
    }

    public Double getGroundLevelValue() {
        return this.groundLevelValue;
    }

    public void setGroundLevelValue(double groundLevelValue) {
        if (groundLevelValue < 0.0) {
            throw new IllegalArgumentException("Atmospheric pressure value must be in [0, +\u221e) range.");
        }
        this.groundLevelValue = groundLevelValue;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AtmosphericPressure)) {
            return false;
        }
        AtmosphericPressure atmosphericPressure = (AtmosphericPressure)o;
        return Double.compare(atmosphericPressure.value, this.value) == 0 && Objects.equals(this.seaLevelValue, atmosphericPressure.seaLevelValue) && Objects.equals(this.groundLevelValue, atmosphericPressure.groundLevelValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.seaLevelValue, this.groundLevelValue);
    }

    public String toString() {
        return "Pressure: " + this.value + ' ' + this.getUnit();
    }
}

