/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model;

import java.util.Objects;

public class Clouds {
    private static final String DEFAULT_UNIT = "%";
    private byte value;

    private Clouds(byte value) {
        this.value = value;
    }

    public static Clouds withValue(byte value) {
        if (value < 0 || value > 100) {
            throw new IllegalArgumentException("Cloudiness value must be in [0, 100] range.");
        }
        return new Clouds(value);
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        if (value < 0 || value > 100) {
            throw new IllegalArgumentException("Cloudiness value must be in [0, 100] range.");
        }
        this.value = value;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Clouds)) {
            return false;
        }
        Clouds clouds = (Clouds)o;
        return this.value == clouds.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Clouds: " + this.value + this.getUnit();
    }
}

