/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model;

import java.util.Objects;

public class Coordinate {
    private double latitude;
    private double longitude;

    private Coordinate() {
    }

    public static Coordinate of(double latitude, double longitude) {
        Coordinate coordinate = new Coordinate();
        coordinate.setLatitude(latitude);
        coordinate.setLongitude(longitude);
        return coordinate;
    }

    public void setLatitude(double latitude) {
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Latitude value must be in the next range: [-90.0; 90.0].");
        }
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Longitude value must be in the next range: [-180.0; 180.0].");
        }
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Coordinate)) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        return Double.compare(that.latitude, this.latitude) == 0 && Double.compare(that.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public String toString() {
        return this.formatAsDegree(this.latitude) + ", " + this.formatAsDegree(this.longitude);
    }

    private String formatAsDegree(double value) {
        int degrees = (int)value;
        double secondsDouble = value % 1.0 * 60.0;
        int minutes = (int)secondsDouble;
        int seconds = (int)(secondsDouble % 1.0 * 60.0);
        return String.format("%s\u00b0 %s\u2032 %s\u2033", degrees, minutes, seconds);
    }
}

