/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model;

import java.util.Objects;

public class CoordinateRectangle {
    private final double longitudeLeft;
    private final double latitudeBottom;
    private final double longitudeRight;
    private final double latitudeTop;

    private CoordinateRectangle(double longitudeLeft, double latitudeBottom, double longitudeRight, double latitudeTop) {
        this.longitudeLeft = longitudeLeft;
        this.latitudeBottom = latitudeBottom;
        this.longitudeRight = longitudeRight;
        this.latitudeTop = latitudeTop;
    }

    public static CoordinateRectangle withValues(double longitudeLeft, double latitudeBottom, double longitudeRight, double latitudeTop) {
        if (latitudeBottom < -90.0 || latitudeTop < -90.0 || latitudeBottom > 90.0 || latitudeTop > 90.0) {
            throw new IllegalArgumentException("Latitude value must be in the next range: [-90.0; 90.0].");
        }
        if (longitudeLeft < -180.0 || longitudeRight < -180.0 || longitudeLeft > 180.0 || longitudeRight > 180.0) {
            throw new IllegalArgumentException("Longitude value must be in the next range: [-180.0; 180.0].");
        }
        return new CoordinateRectangle(longitudeLeft, latitudeBottom, longitudeRight, latitudeTop);
    }

    public double getLongitudeLeft() {
        return this.longitudeLeft;
    }

    public double getLatitudeBottom() {
        return this.latitudeBottom;
    }

    public double getLongitudeRight() {
        return this.longitudeRight;
    }

    public double getLatitudeTop() {
        return this.latitudeTop;
    }

    public String getFormattedRequestString() {
        return this.longitudeLeft + "," + this.latitudeBottom + "," + this.longitudeRight + "," + this.latitudeTop;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CoordinateRectangle)) {
            return false;
        }
        CoordinateRectangle rectangle = (CoordinateRectangle)o;
        return Double.compare(rectangle.longitudeLeft, this.longitudeLeft) == 0 && Double.compare(rectangle.latitudeBottom, this.latitudeBottom) == 0 && Double.compare(rectangle.longitudeRight, this.longitudeRight) == 0 && Double.compare(rectangle.latitudeTop, this.latitudeTop) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.longitudeLeft, this.latitudeBottom, this.longitudeRight, this.latitudeTop);
    }

    public String toString() {
        return "Rectangle: " + this.getFormattedRequestString();
    }

    public static class Builder {
        private Double longitudeLeft;
        private Double latitudeBottom;
        private Double longitudeRight;
        private Double latitudeTop;

        public Builder setLongitudeLeft(double longitudeLeft) {
            if (longitudeLeft < -180.0 || longitudeLeft > 180.0) {
                throw new IllegalArgumentException("Longitude value must be in the next range: [-180.0; 180.0].");
            }
            this.longitudeLeft = longitudeLeft;
            return this;
        }

        public Builder setLatitudeBottom(double latitudeBottom) {
            if (latitudeBottom < -90.0 || latitudeBottom > 90.0) {
                throw new IllegalArgumentException("Latitude value must be in the next range: [-90.0; 90.0].");
            }
            this.latitudeBottom = latitudeBottom;
            return this;
        }

        public Builder setLongitudeRight(double longitudeRight) {
            if (longitudeRight < -180.0 || longitudeRight > 180.0) {
                throw new IllegalArgumentException("Longitude value must be in the next range: [-180.0; 180.0].");
            }
            this.longitudeRight = longitudeRight;
            return this;
        }

        public Builder setLatitudeTop(double latitudeTop) {
            if (latitudeTop < -90.0 || latitudeTop > 90.0) {
                throw new IllegalArgumentException("Latitude value must be in the next range: [-90.0; 90.0].");
            }
            this.latitudeTop = latitudeTop;
            return this;
        }

        public CoordinateRectangle build() {
            if (this.longitudeLeft == null || this.latitudeBottom == null || this.longitudeRight == null || this.latitudeTop == null) {
                throw new IllegalStateException("Not all fields were set.");
            }
            return new CoordinateRectangle(this.longitudeLeft, this.latitudeBottom, this.longitudeRight, this.latitudeTop);
        }
    }
}

