/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model;

import java.util.Objects;

public class Humidity {
    private static final String DEFAULT_UNIT = "%";
    private int value;

    private Humidity(byte value) {
        this.value = value;
    }

    public static Humidity withValue(byte value) {
        if (value < 0 || value > 100) {
            throw new IllegalArgumentException("Humidity value must be in [0, 100] range.");
        }
        return new Humidity(value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value < 0 || value > 100) {
            throw new IllegalArgumentException("Humidity value must be in [0, 100] range.");
        }
        this.value = value;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Humidity)) {
            return false;
        }
        Humidity humidity = (Humidity)o;
        return this.value == humidity.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Humidity: " + this.value + this.getUnit();
    }
}

