/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model;

import java.util.Objects;

public class Temperature {
    private double value;
    private Double maxTemperature;
    private Double minTemperature;
    private Double feelsLike;
    private String unit;

    private Temperature(double value, String unit) {
        this.value = value;
        this.unit = unit;
    }

    public static Temperature withValue(double value, String unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must be set.");
        }
        return new Temperature(value, unit);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public Double getMaxTemperature() {
        return this.maxTemperature;
    }

    public void setMaxTemperature(Double maxTemperature) {
        this.maxTemperature = maxTemperature;
    }

    public Double getMinTemperature() {
        return this.minTemperature;
    }

    public void setMinTemperature(Double minTemperature) {
        this.minTemperature = minTemperature;
    }

    public Double getFeelsLike() {
        return this.feelsLike;
    }

    public void setFeelsLike(Double feelsLike) {
        this.feelsLike = feelsLike;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must be set.");
        }
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Temperature)) {
            return false;
        }
        Temperature that = (Temperature)o;
        return Double.compare(that.value, this.value) == 0 && Objects.equals(this.maxTemperature, that.maxTemperature) && Objects.equals(this.minTemperature, that.minTemperature) && Objects.equals(this.feelsLike, that.feelsLike) && Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.maxTemperature, this.minTemperature, this.feelsLike, this.unit);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Temperature: ");
        stringBuilder.append(this.value);
        stringBuilder.append(' ');
        stringBuilder.append(this.unit);
        if (this.maxTemperature != null) {
            stringBuilder.append(", Maximum value: ");
            stringBuilder.append(this.maxTemperature);
            stringBuilder.append(' ');
            stringBuilder.append(this.unit);
        }
        if (this.minTemperature != null) {
            stringBuilder.append(", Minimum value: ");
            stringBuilder.append(this.minTemperature);
            stringBuilder.append(' ');
            stringBuilder.append(this.unit);
        }
        if (this.feelsLike != null) {
            stringBuilder.append(", Feels like: ");
            stringBuilder.append(this.feelsLike);
            stringBuilder.append(' ');
            stringBuilder.append(this.unit);
        }
        return stringBuilder.toString();
    }
}

