/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model;

import com.github.prominence.openweathermap.api.enums.WeatherCondition;
import java.util.Objects;

public class WeatherState {
    private final int id;
    private final String name;
    private final String description;
    private String iconId;
    private final WeatherCondition weatherConditionEnum;

    public WeatherState(Integer id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.weatherConditionEnum = WeatherCondition.getById(id);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconId() {
        return this.iconId;
    }

    public void setIconId(String iconId) {
        this.iconId = iconId;
    }

    public WeatherCondition getWeatherConditionEnum() {
        return this.weatherConditionEnum;
    }

    public String getWeatherIconUrl() {
        if (this.iconId != null) {
            return WeatherCondition.getIconUrl(this.iconId);
        }
        if (this.weatherConditionEnum != null) {
            return this.weatherConditionEnum.getDayIconUrl();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeatherState that = (WeatherState)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.iconId, that.iconId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.iconId, this.weatherConditionEnum});
    }

    public String toString() {
        return "Weather state: " + this.name + "(" + this.description + ").";
    }
}

