/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.air.pollution;

import com.github.prominence.openweathermap.api.enums.AirQualityIndex;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.stream.Stream;

public class AirPollutionRecord {
    private LocalDateTime forecastTime;
    private AirQualityIndex airQualityIndex;
    private Double CO;
    private Double NO;
    private Double NO2;
    private Double O3;
    private Double SO2;
    private Double PM2_5;
    private Double PM10;
    private Double NH3;

    public LocalDateTime getForecastTime() {
        return this.forecastTime;
    }

    public void setForecastTime(LocalDateTime forecastTime) {
        this.forecastTime = forecastTime;
    }

    public AirQualityIndex getAirQualityIndex() {
        return this.airQualityIndex;
    }

    public void setAirQualityIndex(AirQualityIndex airQualityIndex) {
        this.airQualityIndex = airQualityIndex;
    }

    public Double getCO() {
        return this.CO;
    }

    public Double getCarbonMonoxide() {
        return this.getCO();
    }

    public void setCO(Double CO) {
        this.CO = CO;
    }

    public Double getNO() {
        return this.NO;
    }

    public Double getNitrogenMonoxide() {
        return this.getNO();
    }

    public void setNO(Double NO) {
        this.NO = NO;
    }

    public Double getNO2() {
        return this.NO2;
    }

    public Double getNitrogenDioxide() {
        return this.getNO2();
    }

    public void setNO2(Double NO2) {
        this.NO2 = NO2;
    }

    public Double getO3() {
        return this.O3;
    }

    public Double getOzone() {
        return this.getO3();
    }

    public void setO3(Double o3) {
        this.O3 = o3;
    }

    public Double getSO2() {
        return this.SO2;
    }

    public Double getSulphurDioxide() {
        return this.getSO2();
    }

    public void setSO2(Double SO2) {
        this.SO2 = SO2;
    }

    public Double getPM2_5() {
        return this.PM2_5;
    }

    public Double getFineParticlesMatter() {
        return this.getPM2_5();
    }

    public void setPM2_5(Double PM2_5) {
        this.PM2_5 = PM2_5;
    }

    public Double getPM10() {
        return this.PM10;
    }

    public Double getCoarseParticulateMatter() {
        return this.getPM10();
    }

    public void setPM10(Double PM10) {
        this.PM10 = PM10;
    }

    public Double getNH3() {
        return this.NH3;
    }

    public Double getAmmonia() {
        return this.getNH3();
    }

    public void setNH3(Double NH3) {
        this.NH3 = NH3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AirPollutionRecord that = (AirPollutionRecord)o;
        return Objects.equals(this.forecastTime, that.forecastTime) && this.airQualityIndex == that.airQualityIndex && Objects.equals(this.CO, that.CO) && Objects.equals(this.NO, that.NO) && Objects.equals(this.NO2, that.NO2) && Objects.equals(this.O3, that.O3) && Objects.equals(this.SO2, that.SO2) && Objects.equals(this.PM2_5, that.PM2_5) && Objects.equals(this.PM10, that.PM10) && Objects.equals(this.NH3, that.NH3);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.forecastTime, this.airQualityIndex, this.CO, this.NO, this.NO2, this.O3, this.SO2, this.PM2_5, this.PM10, this.NH3});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Air Pollution Record for ").append(this.forecastTime).append(", AQI=").append(this.airQualityIndex.name()).append(".");
        boolean anyConcentrationAvailable = Stream.of(this.CO, this.NO, this.NO2, this.O3, this.SO2, this.PM2_5, this.PM10, this.NH3).anyMatch(Objects::nonNull);
        if (anyConcentrationAvailable) {
            stringBuilder.append(" Concentrations:");
            if (this.CO != null) {
                stringBuilder.append(" CO(Carbon monoxide) = ").append(this.CO).append(" \u03bcg/m^3;");
            }
            if (this.NO != null) {
                stringBuilder.append(" NO(Nitrogen monoxide) = ").append(this.NO).append(" \u03bcg/m^3;");
            }
            if (this.NO2 != null) {
                stringBuilder.append(" NO2(Nitrogen dioxide) = ").append(this.NO2).append(" \u03bcg/m^3;");
            }
            if (this.O3 != null) {
                stringBuilder.append(" O3(Ozone) = ").append(this.O3).append(" \u03bcg/m^3;");
            }
            if (this.SO2 != null) {
                stringBuilder.append(" SO2(Sulphur dioxide) = ").append(this.SO2).append(" \u03bcg/m^3;");
            }
            if (this.PM2_5 != null) {
                stringBuilder.append(" PM2.5(Fine particles matter) = ").append(this.PM2_5).append(" \u03bcg/m^3;");
            }
            if (this.PM10 != null) {
                stringBuilder.append(" PM10(Coarse particulate matter) = ").append(this.PM10).append(" \u03bcg/m^3;");
            }
            if (this.NH3 != null) {
                stringBuilder.append(" NH3(Ammonia) = ").append(this.NH3).append(" \u03bcg/m^3;");
            }
        }
        return stringBuilder.toString();
    }
}

