/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.forecast;

import java.util.Objects;

public class Rain {
    private static final String DEFAULT_UNIT = "mm";
    private double threeHourLevel;

    private Rain(double threeHourLevel) {
        this.threeHourLevel = threeHourLevel;
    }

    public static Rain withThreeHourLevelValue(double threeHourLevel) {
        if (threeHourLevel < 0.0) {
            throw new IllegalArgumentException("Rain level value cannot be negative.");
        }
        return new Rain(threeHourLevel);
    }

    public double getThreeHourLevel() {
        return this.threeHourLevel;
    }

    public void setThreeHourLevel(double threeHourLevel) {
        if (threeHourLevel < 0.0) {
            throw new IllegalArgumentException("Rain level value cannot be negative.");
        }
        this.threeHourLevel = threeHourLevel;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rain rain = (Rain)o;
        return Double.compare(rain.threeHourLevel, this.threeHourLevel) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.threeHourLevel);
    }

    public String toString() {
        return "3-hour rain level: " + this.threeHourLevel + ' ' + this.getUnit();
    }
}

