/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.forecast;

import com.github.prominence.openweathermap.api.model.AtmosphericPressure;
import com.github.prominence.openweathermap.api.model.Clouds;
import com.github.prominence.openweathermap.api.model.DayTime;
import com.github.prominence.openweathermap.api.model.Humidity;
import com.github.prominence.openweathermap.api.model.Temperature;
import com.github.prominence.openweathermap.api.model.WeatherState;
import com.github.prominence.openweathermap.api.model.forecast.Rain;
import com.github.prominence.openweathermap.api.model.forecast.Snow;
import com.github.prominence.openweathermap.api.model.forecast.Wind;
import java.time.LocalDateTime;
import java.util.Objects;

public class WeatherForecast {
    private LocalDateTime forecastTime;
    private WeatherState weatherState;
    private Temperature temperature;
    private AtmosphericPressure atmosphericPressure;
    private Humidity humidity;
    private Wind wind;
    private Rain rain;
    private Snow snow;
    private Clouds clouds;
    private String forecastTimeISO;
    private DayTime dayTime;

    public LocalDateTime getForecastTime() {
        return this.forecastTime;
    }

    public void setForecastTime(LocalDateTime forecastTime) {
        this.forecastTime = forecastTime;
    }

    public WeatherState getWeatherState() {
        return this.weatherState;
    }

    public void setWeatherState(WeatherState weatherState) {
        this.weatherState = weatherState;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Temperature temperature) {
        this.temperature = temperature;
    }

    public AtmosphericPressure getAtmosphericPressure() {
        return this.atmosphericPressure;
    }

    public void setAtmosphericPressure(AtmosphericPressure atmosphericPressure) {
        this.atmosphericPressure = atmosphericPressure;
    }

    public Humidity getHumidity() {
        return this.humidity;
    }

    public void setHumidity(Humidity humidity) {
        this.humidity = humidity;
    }

    public Wind getWind() {
        return this.wind;
    }

    public void setWind(Wind wind) {
        this.wind = wind;
    }

    public Rain getRain() {
        return this.rain;
    }

    public void setRain(Rain rain) {
        this.rain = rain;
    }

    public Snow getSnow() {
        return this.snow;
    }

    public void setSnow(Snow snow) {
        this.snow = snow;
    }

    public Clouds getClouds() {
        return this.clouds;
    }

    public void setClouds(Clouds clouds) {
        this.clouds = clouds;
    }

    public String getForecastTimeISO() {
        return this.forecastTimeISO;
    }

    public void setForecastTimeISO(String forecastTimeISO) {
        this.forecastTimeISO = forecastTimeISO;
    }

    public DayTime getDayTime() {
        return this.dayTime;
    }

    public void setDayTime(DayTime dayTime) {
        this.dayTime = dayTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeatherForecast that = (WeatherForecast)o;
        return Objects.equals(this.forecastTime, that.forecastTime) && Objects.equals(this.weatherState, that.weatherState) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.atmosphericPressure, that.atmosphericPressure) && Objects.equals(this.humidity, that.humidity) && Objects.equals(this.wind, that.wind) && Objects.equals(this.rain, that.rain) && Objects.equals(this.snow, that.snow) && Objects.equals(this.clouds, that.clouds) && Objects.equals(this.forecastTimeISO, that.forecastTimeISO) && this.dayTime == that.dayTime;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.forecastTime, this.weatherState, this.temperature, this.atmosphericPressure, this.humidity, this.wind, this.rain, this.snow, this.clouds, this.forecastTimeISO, this.dayTime});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Timestamp: ");
        stringBuilder.append(this.forecastTimeISO);
        if (this.weatherState != null) {
            stringBuilder.append(", Weather: ");
            stringBuilder.append(this.weatherState.getDescription());
        }
        if (this.temperature != null) {
            stringBuilder.append(", ");
            stringBuilder.append(this.temperature.getValue());
            stringBuilder.append(' ');
            stringBuilder.append(this.temperature.getUnit());
        }
        if (this.atmosphericPressure != null) {
            stringBuilder.append(", ");
            stringBuilder.append(this.atmosphericPressure.getValue());
            stringBuilder.append(' ');
            stringBuilder.append(this.atmosphericPressure.getUnit());
        }
        if (this.clouds != null) {
            stringBuilder.append(", ");
            stringBuilder.append(this.clouds.toString());
        }
        if (this.rain != null) {
            stringBuilder.append(", Rain: ");
            stringBuilder.append(this.rain.getThreeHourLevel());
            stringBuilder.append(' ');
            stringBuilder.append(this.rain.getUnit());
        }
        if (this.snow != null) {
            stringBuilder.append(", Snow: ");
            stringBuilder.append(this.snow.getThreeHourLevel());
            stringBuilder.append(' ');
            stringBuilder.append(this.snow.getUnit());
        }
        return stringBuilder.toString();
    }
}

