/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall;

import java.util.Objects;

public class AtmosphericPressure {
    private static final String DEFAULT_UNIT = "hPa";
    private double seaLevelValue;

    private AtmosphericPressure() {
    }

    public static AtmosphericPressure withValue(double seaLevelValue) {
        AtmosphericPressure atmosphericPressure = new AtmosphericPressure();
        atmosphericPressure.setSeaLevelValue(seaLevelValue);
        return atmosphericPressure;
    }

    public Double getSeaLevelValue() {
        return this.seaLevelValue;
    }

    public void setSeaLevelValue(double seaLevelValue) {
        if (seaLevelValue < 0.0) {
            throw new IllegalArgumentException("Atmospheric pressure value must be in [0, +\u221e) range.");
        }
        this.seaLevelValue = seaLevelValue;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtmosphericPressure that = (AtmosphericPressure)o;
        return Double.compare(that.seaLevelValue, this.seaLevelValue) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.seaLevelValue);
    }

    public String toString() {
        return "Pressure: " + this.seaLevelValue + ' ' + this.getUnit();
    }
}

