/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall;

import com.github.prominence.openweathermap.api.model.Clouds;
import com.github.prominence.openweathermap.api.model.Humidity;
import com.github.prominence.openweathermap.api.model.WeatherState;
import com.github.prominence.openweathermap.api.model.onecall.AtmosphericPressure;
import com.github.prominence.openweathermap.api.model.onecall.Rain;
import com.github.prominence.openweathermap.api.model.onecall.Snow;
import com.github.prominence.openweathermap.api.model.onecall.Temperature;
import com.github.prominence.openweathermap.api.model.onecall.Wind;
import java.time.LocalDateTime;
import java.util.Objects;

public class Current {
    protected LocalDateTime forecastTime;
    protected LocalDateTime sunriseTime;
    protected LocalDateTime sunsetTime;
    protected WeatherState weatherState;
    protected Temperature temperature;
    protected AtmosphericPressure atmosphericPressure;
    protected Humidity humidity;
    protected Clouds clouds;
    protected Double uvIndex;
    protected Double visibilityInMetres;
    protected Wind wind;
    protected Rain rain;
    protected Snow snow;

    public LocalDateTime getForecastTime() {
        return this.forecastTime;
    }

    public void setForecastTime(LocalDateTime forecastTime) {
        this.forecastTime = forecastTime;
    }

    public LocalDateTime getSunriseTime() {
        return this.sunriseTime;
    }

    public void setSunriseTime(LocalDateTime sunriseTime) {
        this.sunriseTime = sunriseTime;
    }

    public LocalDateTime getSunsetTime() {
        return this.sunsetTime;
    }

    public void setSunsetTime(LocalDateTime sunsetTime) {
        this.sunsetTime = sunsetTime;
    }

    public WeatherState getWeatherState() {
        return this.weatherState;
    }

    public void setWeatherState(WeatherState weatherState) {
        this.weatherState = weatherState;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Temperature temperature) {
        this.temperature = temperature;
    }

    public AtmosphericPressure getAtmosphericPressure() {
        return this.atmosphericPressure;
    }

    public void setAtmosphericPressure(AtmosphericPressure atmosphericPressure) {
        this.atmosphericPressure = atmosphericPressure;
    }

    public Humidity getHumidity() {
        return this.humidity;
    }

    public void setHumidity(Humidity humidity) {
        this.humidity = humidity;
    }

    public Clouds getClouds() {
        return this.clouds;
    }

    public void setClouds(Clouds clouds) {
        this.clouds = clouds;
    }

    public Double getUvIndex() {
        return this.uvIndex;
    }

    public void setUvIndex(Double uvIndex) {
        if (uvIndex != null && uvIndex < 0.0) {
            throw new IllegalArgumentException("UV index must not be negative.");
        }
        this.uvIndex = uvIndex;
    }

    public Double getVisibilityInMetres() {
        return this.visibilityInMetres;
    }

    public void setVisibilityInMetres(Double visibilityInMetres) {
        if (visibilityInMetres != null && visibilityInMetres < 0.0) {
            throw new IllegalArgumentException("Visibility must not be negative.");
        }
        this.visibilityInMetres = visibilityInMetres;
    }

    public Wind getWind() {
        return this.wind;
    }

    public void setWind(Wind wind) {
        this.wind = wind;
    }

    public Rain getRain() {
        return this.rain;
    }

    public void setRain(Rain rain) {
        this.rain = rain;
    }

    public Snow getSnow() {
        return this.snow;
    }

    public void setSnow(Snow snow) {
        this.snow = snow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Current current = (Current)o;
        return Objects.equals(this.forecastTime, current.forecastTime) && Objects.equals(this.sunriseTime, current.sunriseTime) && Objects.equals(this.sunsetTime, current.sunsetTime) && Objects.equals(this.weatherState, current.weatherState) && Objects.equals(this.temperature, current.temperature) && Objects.equals(this.atmosphericPressure, current.atmosphericPressure) && Objects.equals(this.humidity, current.humidity) && Objects.equals(this.clouds, current.clouds) && Objects.equals(this.uvIndex, current.uvIndex) && Objects.equals(this.visibilityInMetres, current.visibilityInMetres) && Objects.equals(this.wind, current.wind) && Objects.equals(this.rain, current.rain) && Objects.equals(this.snow, current.snow);
    }

    public int hashCode() {
        return Objects.hash(this.forecastTime, this.sunriseTime, this.sunsetTime, this.weatherState, this.temperature, this.atmosphericPressure, this.humidity, this.clouds, this.uvIndex, this.visibilityInMetres, this.wind, this.rain, this.snow);
    }

    public String toString() {
        return "Current weather information forecasted for " + this.forecastTime + ".";
    }
}

