/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall;

import java.util.Objects;

public class Rain {
    private static final String DEFAULT_UNIT = "mm";
    private double oneHourLevel;

    private Rain() {
    }

    public static Rain withOneHourLevelValue(double oneHourLevel) {
        Rain rain = new Rain();
        rain.setOneHourLevel(oneHourLevel);
        return rain;
    }

    public double getOneHourLevel() {
        return this.oneHourLevel;
    }

    public void setOneHourLevel(double oneHourLevel) {
        if (oneHourLevel < 0.0) {
            throw new IllegalArgumentException("Rain level value cannot be negative.");
        }
        this.oneHourLevel = oneHourLevel;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rain)) {
            return false;
        }
        Rain rain = (Rain)o;
        return Objects.equals(this.oneHourLevel, rain.oneHourLevel);
    }

    public int hashCode() {
        return Objects.hash(this.oneHourLevel);
    }

    public String toString() {
        return "1-hour rain level: " + this.oneHourLevel + ' ' + this.getUnit();
    }
}

