/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall;

import java.util.Objects;

public class Snow {
    private static final String DEFAULT_UNIT = "mm";
    private double oneHourLevel;

    private Snow() {
    }

    public static Snow withOneHourLevelValue(double oneHourLevel) {
        Snow snow = new Snow();
        snow.setOneHourLevel(oneHourLevel);
        return snow;
    }

    public double getOneHourLevel() {
        return this.oneHourLevel;
    }

    public void setOneHourLevel(double oneHourLevel) {
        if (oneHourLevel < 0.0) {
            throw new IllegalArgumentException("Snow level value cannot be negative.");
        }
        this.oneHourLevel = oneHourLevel;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Snow)) {
            return false;
        }
        Snow snow = (Snow)o;
        return Objects.equals(this.oneHourLevel, snow.oneHourLevel);
    }

    public int hashCode() {
        return Objects.hash(this.oneHourLevel);
    }

    public String toString() {
        return "1-hour snow level: " + this.oneHourLevel + ' ' + this.getUnit();
    }
}

