/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall;

import java.util.Objects;

public class Temperature {
    private double value;
    private Double feelsLike;
    private Double dewPoint;
    private String unit;

    private Temperature() {
    }

    public static Temperature withValue(double value, String unit) {
        Temperature temperature = new Temperature();
        temperature.setValue(value);
        temperature.setUnit(unit);
        return temperature;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public Double getFeelsLike() {
        return this.feelsLike;
    }

    public void setFeelsLike(Double feelsLike) {
        this.feelsLike = feelsLike;
    }

    public Double getDewPoint() {
        return this.dewPoint;
    }

    public void setDewPoint(Double dewPoint) {
        this.dewPoint = dewPoint;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must be set.");
        }
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Temperature)) {
            return false;
        }
        Temperature that = (Temperature)o;
        return Double.compare(that.value, this.value) == 0 && Objects.equals(this.feelsLike, that.feelsLike) && Objects.equals(this.dewPoint, that.dewPoint) && Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.feelsLike, this.dewPoint, this.unit);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Temperature: ");
        stringBuilder.append(this.value);
        stringBuilder.append(' ');
        stringBuilder.append(this.unit);
        if (this.feelsLike != null) {
            stringBuilder.append(", Feels like: ");
            stringBuilder.append(this.feelsLike);
            stringBuilder.append(' ');
            stringBuilder.append(this.unit);
        }
        return stringBuilder.toString();
    }
}

