/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall.current;

import com.github.prominence.openweathermap.api.model.Clouds;
import com.github.prominence.openweathermap.api.model.Humidity;
import com.github.prominence.openweathermap.api.model.WeatherState;
import com.github.prominence.openweathermap.api.model.onecall.AtmosphericPressure;
import com.github.prominence.openweathermap.api.model.onecall.Wind;
import com.github.prominence.openweathermap.api.model.onecall.current.DailyRain;
import com.github.prominence.openweathermap.api.model.onecall.current.DailySnow;
import com.github.prominence.openweathermap.api.model.onecall.current.DailyTemperature;
import com.github.prominence.openweathermap.api.model.onecall.current.MoonPhase;
import java.time.LocalDateTime;
import java.util.Objects;

public class Daily {
    private LocalDateTime forecastTime;
    private LocalDateTime sunriseTime;
    private LocalDateTime sunsetTime;
    private LocalDateTime moonriseTime;
    private LocalDateTime moonsetTime;
    private MoonPhase moonPhase;
    private WeatherState weatherState;
    private DailyTemperature temperature;
    private AtmosphericPressure atmosphericPressure;
    private Humidity humidity;
    private Wind wind;
    private Clouds clouds;
    private Double uvIndex;
    private Double probabilityOfPrecipitation;
    private DailyRain rain;
    private DailySnow snow;

    public LocalDateTime getForecastTime() {
        return this.forecastTime;
    }

    public void setForecastTime(LocalDateTime forecastTime) {
        this.forecastTime = forecastTime;
    }

    public LocalDateTime getSunriseTime() {
        return this.sunriseTime;
    }

    public void setSunriseTime(LocalDateTime sunriseTime) {
        this.sunriseTime = sunriseTime;
    }

    public LocalDateTime getSunsetTime() {
        return this.sunsetTime;
    }

    public void setSunsetTime(LocalDateTime sunsetTime) {
        this.sunsetTime = sunsetTime;
    }

    public LocalDateTime getMoonriseTime() {
        return this.moonriseTime;
    }

    public void setMoonriseTime(LocalDateTime moonriseTime) {
        this.moonriseTime = moonriseTime;
    }

    public LocalDateTime getMoonsetTime() {
        return this.moonsetTime;
    }

    public void setMoonsetTime(LocalDateTime moonsetTime) {
        this.moonsetTime = moonsetTime;
    }

    public MoonPhase getMoonPhase() {
        return this.moonPhase;
    }

    public void setMoonPhase(MoonPhase moonPhase) {
        this.moonPhase = moonPhase;
    }

    public WeatherState getWeatherState() {
        return this.weatherState;
    }

    public void setWeatherState(WeatherState weatherState) {
        this.weatherState = weatherState;
    }

    public DailyTemperature getTemperature() {
        return this.temperature;
    }

    public void setTemperature(DailyTemperature temperature) {
        this.temperature = temperature;
    }

    public AtmosphericPressure getAtmosphericPressure() {
        return this.atmosphericPressure;
    }

    public void setAtmosphericPressure(AtmosphericPressure atmosphericPressure) {
        this.atmosphericPressure = atmosphericPressure;
    }

    public Humidity getHumidity() {
        return this.humidity;
    }

    public void setHumidity(Humidity humidity) {
        this.humidity = humidity;
    }

    public Wind getWind() {
        return this.wind;
    }

    public void setWind(Wind wind) {
        this.wind = wind;
    }

    public Clouds getClouds() {
        return this.clouds;
    }

    public void setClouds(Clouds clouds) {
        this.clouds = clouds;
    }

    public Double getUvIndex() {
        return this.uvIndex;
    }

    public void setUvIndex(Double uvIndex) {
        if (uvIndex != null && uvIndex < 0.0) {
            throw new IllegalArgumentException("UV index must not be negative.");
        }
        this.uvIndex = uvIndex;
    }

    public Double getProbabilityOfPrecipitation() {
        return this.probabilityOfPrecipitation;
    }

    public void setProbabilityOfPrecipitation(Double probabilityOfPrecipitation) {
        if (probabilityOfPrecipitation != null && (probabilityOfPrecipitation < 0.0 || probabilityOfPrecipitation > 100.0)) {
            throw new IllegalArgumentException("Probability of precipitation value must be in [0, 100] range.");
        }
        this.probabilityOfPrecipitation = probabilityOfPrecipitation;
    }

    public Byte getProbabilityOfPrecipitationPercentage() {
        if (this.probabilityOfPrecipitation != null) {
            return (byte)(this.probabilityOfPrecipitation * 100.0);
        }
        return null;
    }

    public DailyRain getRain() {
        return this.rain;
    }

    public void setRain(DailyRain rain) {
        this.rain = rain;
    }

    public DailySnow getSnow() {
        return this.snow;
    }

    public void setSnow(DailySnow snow) {
        this.snow = snow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Daily daily = (Daily)o;
        return Objects.equals(this.forecastTime, daily.forecastTime) && Objects.equals(this.sunriseTime, daily.sunriseTime) && Objects.equals(this.sunsetTime, daily.sunsetTime) && Objects.equals(this.moonriseTime, daily.moonriseTime) && Objects.equals(this.moonsetTime, daily.moonsetTime) && Objects.equals(this.moonPhase, daily.moonPhase) && Objects.equals(this.weatherState, daily.weatherState) && Objects.equals(this.temperature, daily.temperature) && Objects.equals(this.atmosphericPressure, daily.atmosphericPressure) && Objects.equals(this.humidity, daily.humidity) && Objects.equals(this.wind, daily.wind) && Objects.equals(this.clouds, daily.clouds) && Objects.equals(this.uvIndex, daily.uvIndex) && Objects.equals(this.probabilityOfPrecipitation, daily.probabilityOfPrecipitation) && Objects.equals(this.rain, daily.rain) && Objects.equals(this.snow, daily.snow);
    }

    public int hashCode() {
        return Objects.hash(this.forecastTime, this.sunriseTime, this.sunsetTime, this.moonriseTime, this.moonsetTime, this.moonPhase, this.weatherState, this.temperature, this.atmosphericPressure, this.humidity, this.wind, this.clouds, this.uvIndex, this.probabilityOfPrecipitation, this.rain, this.snow);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Weather on ");
        stringBuilder.append(this.forecastTime);
        stringBuilder.append(".");
        if (this.weatherState != null) {
            stringBuilder.append(" Weather: ");
            stringBuilder.append(this.weatherState.getDescription());
            stringBuilder.append('.');
        }
        if (this.temperature != null) {
            stringBuilder.append(" Temperature(day): ");
            stringBuilder.append(this.temperature.getDay());
            stringBuilder.append(' ');
            stringBuilder.append(this.temperature.getUnit());
            stringBuilder.append('.');
        }
        if (this.atmosphericPressure != null) {
            stringBuilder.append(" Atmospheric pressure: ");
            stringBuilder.append(this.atmosphericPressure.getSeaLevelValue());
            stringBuilder.append(' ');
            stringBuilder.append(this.atmosphericPressure.getUnit());
            stringBuilder.append('.');
        }
        if (this.clouds != null) {
            stringBuilder.append(" Clouds: ");
            stringBuilder.append(this.clouds);
            stringBuilder.append('.');
        }
        if (this.rain != null) {
            stringBuilder.append(" Rain: ");
            stringBuilder.append(this.rain.getValue());
            stringBuilder.append(' ');
            stringBuilder.append(this.rain.getUnit());
            stringBuilder.append('.');
        }
        if (this.snow != null) {
            stringBuilder.append(". Snow: ");
            stringBuilder.append(this.snow.getValue());
            stringBuilder.append(' ');
            stringBuilder.append(this.snow.getUnit());
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }
}

