/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall.current;

import java.util.Objects;

public class DailyRain {
    private static final String DEFAULT_UNIT = "mm";
    private double value;

    private DailyRain() {
    }

    public static DailyRain withValue(double value) {
        DailyRain rain = new DailyRain();
        rain.setValue(value);
        return rain;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Rain level value cannot be negative.");
        }
        this.value = value;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DailyRain)) {
            return false;
        }
        DailyRain rain = (DailyRain)o;
        return Objects.equals(this.value, rain.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Rain level: " + this.value + this.getUnit();
    }
}

