/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall.current;

import java.util.Objects;

public class DailySnow {
    private static final String DEFAULT_UNIT = "mm";
    private double value;

    private DailySnow() {
    }

    public static DailySnow withValue(double value) {
        DailySnow snow = new DailySnow();
        snow.setValue(value);
        return snow;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Snow level value cannot be negative.");
        }
        this.value = value;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DailySnow)) {
            return false;
        }
        DailySnow snow = (DailySnow)o;
        return Objects.equals(this.value, snow.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Snow level: " + this.value + this.getUnit();
    }
}

