/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall.current;

import com.github.prominence.openweathermap.api.model.Clouds;
import com.github.prominence.openweathermap.api.model.Humidity;
import com.github.prominence.openweathermap.api.model.WeatherState;
import com.github.prominence.openweathermap.api.model.onecall.AtmosphericPressure;
import com.github.prominence.openweathermap.api.model.onecall.Rain;
import com.github.prominence.openweathermap.api.model.onecall.Snow;
import com.github.prominence.openweathermap.api.model.onecall.Temperature;
import com.github.prominence.openweathermap.api.model.onecall.Wind;
import java.time.LocalDateTime;
import java.util.Objects;

public class Hourly {
    private LocalDateTime forecastTime;
    private WeatherState weatherState;
    private Temperature temperature;
    private AtmosphericPressure atmosphericPressure;
    private Humidity humidity;
    private Double uvIndex;
    private Clouds clouds;
    private Double visibilityInMetres;
    private Wind wind;
    private Double probabilityOfPrecipitation;
    private Rain rain;
    private Snow snow;

    public LocalDateTime getForecastTime() {
        return this.forecastTime;
    }

    public void setForecastTime(LocalDateTime forecastTime) {
        this.forecastTime = forecastTime;
    }

    public WeatherState getWeatherState() {
        return this.weatherState;
    }

    public void setWeatherState(WeatherState weatherState) {
        this.weatherState = weatherState;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Temperature temperature) {
        this.temperature = temperature;
    }

    public AtmosphericPressure getAtmosphericPressure() {
        return this.atmosphericPressure;
    }

    public void setAtmosphericPressure(AtmosphericPressure atmosphericPressure) {
        this.atmosphericPressure = atmosphericPressure;
    }

    public Humidity getHumidity() {
        return this.humidity;
    }

    public void setHumidity(Humidity humidity) {
        this.humidity = humidity;
    }

    public Double getUvIndex() {
        return this.uvIndex;
    }

    public void setUvIndex(Double uvIndex) {
        this.uvIndex = uvIndex;
    }

    public Clouds getClouds() {
        return this.clouds;
    }

    public void setClouds(Clouds clouds) {
        this.clouds = clouds;
    }

    public Double getVisibilityInMetres() {
        return this.visibilityInMetres;
    }

    public void setVisibilityInMetres(Double visibilityInMetres) {
        this.visibilityInMetres = visibilityInMetres;
    }

    public Wind getWind() {
        return this.wind;
    }

    public void setWind(Wind wind) {
        this.wind = wind;
    }

    public Double getProbabilityOfPrecipitation() {
        return this.probabilityOfPrecipitation;
    }

    public void setProbabilityOfPrecipitation(Double probabilityOfPrecipitation) {
        if (probabilityOfPrecipitation != null && (probabilityOfPrecipitation < 0.0 || probabilityOfPrecipitation > 100.0)) {
            throw new IllegalArgumentException("Probability of precipitation value must be in [0, 100] range.");
        }
        this.probabilityOfPrecipitation = probabilityOfPrecipitation;
    }

    public Byte getProbabilityOfPrecipitationPercentage() {
        if (this.probabilityOfPrecipitation != null) {
            return (byte)(this.probabilityOfPrecipitation * 100.0);
        }
        return null;
    }

    public Rain getRain() {
        return this.rain;
    }

    public void setRain(Rain rain) {
        this.rain = rain;
    }

    public Snow getSnow() {
        return this.snow;
    }

    public void setSnow(Snow snow) {
        this.snow = snow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hourly hourly = (Hourly)o;
        return Objects.equals(this.forecastTime, hourly.forecastTime) && Objects.equals(this.weatherState, hourly.weatherState) && Objects.equals(this.temperature, hourly.temperature) && Objects.equals(this.atmosphericPressure, hourly.atmosphericPressure) && Objects.equals(this.humidity, hourly.humidity) && Objects.equals(this.uvIndex, hourly.uvIndex) && Objects.equals(this.clouds, hourly.clouds) && Objects.equals(this.visibilityInMetres, hourly.visibilityInMetres) && Objects.equals(this.wind, hourly.wind) && Objects.equals(this.probabilityOfPrecipitation, hourly.probabilityOfPrecipitation) && Objects.equals(this.rain, hourly.rain) && Objects.equals(this.snow, hourly.snow);
    }

    public int hashCode() {
        return Objects.hash(this.forecastTime, this.weatherState, this.temperature, this.atmosphericPressure, this.humidity, this.uvIndex, this.clouds, this.visibilityInMetres, this.wind, this.probabilityOfPrecipitation, this.rain, this.snow);
    }

    public String toString() {
        return "Hourly weather information forecasted for " + this.forecastTime + ".";
    }
}

