/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.onecall.current;

import java.time.LocalDateTime;
import java.util.Objects;

public class Minutely {
    private LocalDateTime forecastTime;
    private double precipitationVolume;

    private Minutely() {
    }

    public static Minutely withValue(LocalDateTime forecastTime, double precipitationVolume) {
        Minutely minutely = new Minutely();
        minutely.setForecastTime(forecastTime);
        minutely.setPrecipitationVolume(precipitationVolume);
        return minutely;
    }

    public LocalDateTime getForecastTime() {
        return this.forecastTime;
    }

    private void setForecastTime(LocalDateTime forecastTime) {
        Objects.requireNonNull(forecastTime);
        this.forecastTime = forecastTime;
    }

    public double getPrecipitationVolume() {
        return this.precipitationVolume;
    }

    private void setPrecipitationVolume(double precipitationVolume) {
        if (precipitationVolume < 0.0) {
            throw new IllegalArgumentException("Precipitation volume cannot be negative.");
        }
        this.precipitationVolume = precipitationVolume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Minutely minutely = (Minutely)o;
        return Double.compare(minutely.precipitationVolume, this.precipitationVolume) == 0 && Objects.equals(this.forecastTime, minutely.forecastTime);
    }

    public int hashCode() {
        return Objects.hash(this.forecastTime, this.precipitationVolume);
    }

    public String toString() {
        return "Time: " + this.forecastTime + ", precipitation volume: " + this.precipitationVolume;
    }
}

