/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.weather;

import com.github.prominence.openweathermap.api.model.Coordinate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public class Location {
    private int id;
    private String name;
    private String countryCode;
    private LocalDateTime sunriseTime;
    private LocalDateTime sunsetTime;
    private ZoneOffset zoneOffset;
    private Coordinate coordinate;

    private Location(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static Location withValues(int id, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must be set.");
        }
        return new Location(id, name);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public LocalDateTime getSunriseTime() {
        return this.sunriseTime;
    }

    public void setSunriseTime(LocalDateTime sunriseTime) {
        this.sunriseTime = sunriseTime;
    }

    public LocalDateTime getSunsetTime() {
        return this.sunsetTime;
    }

    public void setSunsetTime(LocalDateTime sunsetTime) {
        this.sunsetTime = sunsetTime;
    }

    public ZoneOffset getZoneOffset() {
        return this.zoneOffset;
    }

    public void setZoneOffset(ZoneOffset zoneOffset) {
        this.zoneOffset = zoneOffset;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        return this.id == location.id && Objects.equals(this.name, location.name) && Objects.equals(this.countryCode, location.countryCode) && Objects.equals(this.sunriseTime, location.sunriseTime) && Objects.equals(this.sunsetTime, location.sunsetTime) && Objects.equals(this.zoneOffset, location.zoneOffset) && Objects.equals(this.coordinate, location.coordinate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.countryCode, this.sunriseTime, this.sunsetTime, this.zoneOffset, this.coordinate);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.coordinate != null) {
            stringBuilder.append(this.coordinate.toString());
            stringBuilder.append(". ");
        }
        stringBuilder.append("ID: ");
        stringBuilder.append(this.id);
        stringBuilder.append(", Name: ");
        stringBuilder.append(this.name);
        if (this.countryCode != null) {
            stringBuilder.append('(');
            stringBuilder.append(this.countryCode);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

