/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.weather;

import java.util.Objects;

public class Rain {
    private static final String DEFAULT_UNIT = "mm";
    private Double oneHourLevel;
    private Double threeHourLevel;

    private Rain() {
    }

    public static Rain withOneHourLevelValue(double oneHourLevel) {
        Rain rain = new Rain();
        rain.setOneHourLevel(oneHourLevel);
        return rain;
    }

    public static Rain withThreeHourLevelValue(double threeHourLevel) {
        Rain rain = new Rain();
        rain.setThreeHourLevel(threeHourLevel);
        return rain;
    }

    public static Rain withValues(double oneHourLevel, double threeHourLevel) {
        Rain rain = new Rain();
        rain.setOneHourLevel(oneHourLevel);
        rain.setThreeHourLevel(threeHourLevel);
        return rain;
    }

    public Double getOneHourLevel() {
        return this.oneHourLevel;
    }

    public void setOneHourLevel(double oneHourLevel) {
        if (oneHourLevel < 0.0) {
            throw new IllegalArgumentException("Rain level value cannot be negative.");
        }
        this.oneHourLevel = oneHourLevel;
    }

    public Double getThreeHourLevel() {
        return this.threeHourLevel;
    }

    public void setThreeHourLevel(double threeHourLevel) {
        if (threeHourLevel < 0.0) {
            throw new IllegalArgumentException("Rain level value cannot be negative.");
        }
        this.threeHourLevel = threeHourLevel;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rain)) {
            return false;
        }
        Rain rain = (Rain)o;
        return Objects.equals(this.oneHourLevel, rain.oneHourLevel) && Objects.equals(this.threeHourLevel, rain.threeHourLevel);
    }

    public int hashCode() {
        return Objects.hash(this.oneHourLevel, this.threeHourLevel);
    }

    public String toString() {
        StringBuilder snowString = new StringBuilder();
        if (this.oneHourLevel != null) {
            snowString.append("1-hour rain level: ");
            snowString.append(this.oneHourLevel);
            snowString.append(this.getUnit());
        }
        if (this.threeHourLevel != null) {
            if (this.oneHourLevel != null) {
                snowString.append(", ");
            }
            snowString.append("3-hours rain level: ");
            snowString.append(this.threeHourLevel);
            snowString.append(this.getUnit());
        }
        return snowString.toString();
    }
}

