/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.weather;

import java.util.Objects;

public class Snow {
    private static final String DEFAULT_UNIT = "mm";
    private Double oneHourLevel;
    private Double threeHourLevel;

    private Snow() {
    }

    public static Snow withOneHourLevelValue(double oneHourLevel) {
        Snow snow = new Snow();
        snow.setOneHourLevel(oneHourLevel);
        return snow;
    }

    public static Snow withThreeHourLevelValue(double threeHourLevel) {
        Snow snow = new Snow();
        snow.setThreeHourLevel(threeHourLevel);
        return snow;
    }

    public static Snow withValues(double oneHourLevel, double threeHourLevel) {
        Snow snow = new Snow();
        snow.setOneHourLevel(oneHourLevel);
        snow.setThreeHourLevel(threeHourLevel);
        return snow;
    }

    public Double getOneHourLevel() {
        return this.oneHourLevel;
    }

    public void setOneHourLevel(double oneHourLevel) {
        if (oneHourLevel < 0.0) {
            throw new IllegalArgumentException("Snow level value cannot be negative.");
        }
        this.oneHourLevel = oneHourLevel;
    }

    public Double getThreeHourLevel() {
        return this.threeHourLevel;
    }

    public void setThreeHourLevel(double threeHourLevel) {
        if (threeHourLevel < 0.0) {
            throw new IllegalArgumentException("Snow level value cannot be negative.");
        }
        this.threeHourLevel = threeHourLevel;
    }

    public String getUnit() {
        return DEFAULT_UNIT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Snow)) {
            return false;
        }
        Snow snow = (Snow)o;
        return Objects.equals(this.oneHourLevel, snow.oneHourLevel) && Objects.equals(this.threeHourLevel, snow.threeHourLevel);
    }

    public int hashCode() {
        return Objects.hash(this.oneHourLevel, this.threeHourLevel);
    }

    public String toString() {
        StringBuilder snowString = new StringBuilder();
        if (this.oneHourLevel != null) {
            snowString.append("1-hour snow level: ");
            snowString.append(this.oneHourLevel);
            snowString.append(this.getUnit());
        }
        if (this.threeHourLevel != null) {
            if (this.oneHourLevel != null) {
                snowString.append(", ");
            }
            snowString.append("3-hours snow level: ");
            snowString.append(this.threeHourLevel);
            snowString.append(this.getUnit());
        }
        return snowString.toString();
    }
}

