/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.weather;

import com.github.prominence.openweathermap.api.model.AtmosphericPressure;
import com.github.prominence.openweathermap.api.model.Clouds;
import com.github.prominence.openweathermap.api.model.Humidity;
import com.github.prominence.openweathermap.api.model.Temperature;
import com.github.prominence.openweathermap.api.model.WeatherState;
import com.github.prominence.openweathermap.api.model.weather.Location;
import com.github.prominence.openweathermap.api.model.weather.Rain;
import com.github.prominence.openweathermap.api.model.weather.Snow;
import com.github.prominence.openweathermap.api.model.weather.Wind;
import java.time.LocalDateTime;
import java.util.Objects;

public class Weather {
    private LocalDateTime calculationTime;
    private WeatherState weatherState;
    private Temperature temperature;
    private AtmosphericPressure atmosphericPressure;
    private Humidity humidity;
    private Wind wind;
    private Rain rain;
    private Snow snow;
    private Clouds clouds;
    private Location location;

    public LocalDateTime getCalculationTime() {
        return this.calculationTime;
    }

    public void setCalculationTime(LocalDateTime calculationTime) {
        this.calculationTime = calculationTime;
    }

    public WeatherState getWeatherState() {
        return this.weatherState;
    }

    public void setWeatherState(WeatherState weatherState) {
        this.weatherState = weatherState;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Temperature temperature) {
        this.temperature = temperature;
    }

    public AtmosphericPressure getAtmosphericPressure() {
        return this.atmosphericPressure;
    }

    public void setAtmosphericPressure(AtmosphericPressure atmosphericPressure) {
        this.atmosphericPressure = atmosphericPressure;
    }

    public Humidity getHumidity() {
        return this.humidity;
    }

    public void setHumidity(Humidity humidity) {
        this.humidity = humidity;
    }

    public Wind getWind() {
        return this.wind;
    }

    public void setWind(Wind wind) {
        this.wind = wind;
    }

    public Rain getRain() {
        return this.rain;
    }

    public void setRain(Rain rain) {
        this.rain = rain;
    }

    public Snow getSnow() {
        return this.snow;
    }

    public void setSnow(Snow snow) {
        this.snow = snow;
    }

    public Clouds getClouds() {
        return this.clouds;
    }

    public void setClouds(Clouds clouds) {
        this.clouds = clouds;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Weather)) {
            return false;
        }
        Weather weather = (Weather)o;
        return Objects.equals(this.calculationTime, weather.calculationTime) && Objects.equals(this.weatherState, weather.weatherState) && Objects.equals(this.temperature, weather.temperature) && Objects.equals(this.atmosphericPressure, weather.atmosphericPressure) && Objects.equals(this.humidity, weather.humidity) && Objects.equals(this.wind, weather.wind) && Objects.equals(this.rain, weather.rain) && Objects.equals(this.snow, weather.snow) && Objects.equals(this.clouds, weather.clouds) && Objects.equals(this.location, weather.location);
    }

    public int hashCode() {
        return Objects.hash(this.calculationTime, this.weatherState, this.temperature, this.atmosphericPressure, this.humidity, this.wind, this.rain, this.snow, this.clouds, this.location);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.location != null) {
            stringBuilder.append("Location: ");
            stringBuilder.append(this.location.getName());
            String countryCode = this.location.getCountryCode();
            if (countryCode != null) {
                stringBuilder.append('(');
                stringBuilder.append(countryCode);
                stringBuilder.append(')');
            }
        }
        if (this.weatherState != null) {
            stringBuilder.append(", Weather: ");
            stringBuilder.append(this.weatherState.getDescription());
        }
        if (this.temperature != null) {
            stringBuilder.append(", ");
            stringBuilder.append(this.temperature.getValue());
            stringBuilder.append(' ');
            stringBuilder.append(this.temperature.getUnit());
        }
        if (this.atmosphericPressure != null) {
            stringBuilder.append(", ");
            stringBuilder.append(this.atmosphericPressure.getValue());
            stringBuilder.append(' ');
            stringBuilder.append(this.atmosphericPressure.getUnit());
        }
        if (this.clouds != null) {
            stringBuilder.append(", ");
            stringBuilder.append(this.clouds.toString());
        }
        if (this.rain != null && this.rain.getOneHourLevel() != null) {
            stringBuilder.append(", Rain: ");
            stringBuilder.append(this.rain.getOneHourLevel());
            stringBuilder.append(' ');
            stringBuilder.append(this.rain.getUnit());
        }
        if (this.snow != null && this.snow.getOneHourLevel() != null) {
            stringBuilder.append(", Snow: ");
            stringBuilder.append(this.snow.getOneHourLevel());
            stringBuilder.append(' ');
            stringBuilder.append(this.snow.getUnit());
        }
        return stringBuilder.toString();
    }
}

