/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.model.weather;

import java.util.Objects;

public class Wind {
    private double speed;
    private Double degrees;
    private Double gust;
    private String unit;

    private Wind(double speed, String unit) {
        this.speed = speed;
        this.unit = unit;
    }

    public static Wind withValue(double speed, String unit) {
        if (speed < 0.0) {
            throw new IllegalArgumentException("Wind speed value must be in positive or zero.");
        }
        if (unit == null) {
            throw new IllegalArgumentException("Unit must be set.");
        }
        return new Wind(speed, unit);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        if (speed < 0.0) {
            throw new IllegalArgumentException("Wind speed value must be in positive or zero.");
        }
        this.speed = speed;
    }

    public Double getGust() {
        return this.gust;
    }

    public void setGust(double gust) {
        if (gust < 0.0) {
            throw new IllegalArgumentException("Gust value must be positive or zero.");
        }
        this.gust = gust;
    }

    public Double getDegrees() {
        return this.degrees;
    }

    public void setDegrees(double degrees) {
        if (degrees < 0.0 || degrees > 360.0) {
            throw new IllegalArgumentException("Wind direction value must be in [0, 360] range.");
        }
        this.degrees = degrees;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must be set.");
        }
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Wind)) {
            return false;
        }
        Wind wind = (Wind)o;
        return Double.compare(wind.speed, this.speed) == 0 && Objects.equals(this.degrees, wind.degrees) && Objects.equals(this.gust, wind.gust) && Objects.equals(this.unit, wind.unit);
    }

    public int hashCode() {
        return Objects.hash(this.speed, this.degrees, this.gust, this.unit);
    }

    public String toString() {
        String output = "Wind speed: " + this.speed + " " + this.unit + ", degrees: " + this.degrees;
        if (this.gust != null) {
            output = output + ", Gust: " + this.gust + " " + this.unit;
        }
        return output;
    }
}

