/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.request;

import com.github.prominence.openweathermap.api.conf.TimeoutSettings;
import com.github.prominence.openweathermap.api.enums.Language;
import com.github.prominence.openweathermap.api.enums.ResponseType;
import com.github.prominence.openweathermap.api.enums.UnitSystem;
import java.util.HashMap;
import java.util.Map;

public class RequestSettings {
    private static final String LANG_PARAM = "lang";
    private static final String UNITS_PARAM = "units";
    private static final String MODE_PARAM = "mode";
    private static final String API_KEY_PARAM_NAME = "appid";
    private final TimeoutSettings timeoutSettings;
    private final Map<String, String> requestParameters = new HashMap<String, String>(8);
    private final StringBuilder urlAppenderBuilder = new StringBuilder("");
    private Language language = Language.ENGLISH;
    private UnitSystem unitSystem = UnitSystem.STANDARD;

    public RequestSettings(String apiKey, TimeoutSettings timeoutSettings) {
        this.putRequestParameter(API_KEY_PARAM_NAME, apiKey);
        this.timeoutSettings = new TimeoutSettings(timeoutSettings);
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    public UnitSystem getUnitSystem() {
        return this.unitSystem;
    }

    public void setUnitSystem(UnitSystem unitSystem) {
        this.putRequestParameter(UNITS_PARAM, unitSystem.getValue());
        this.unitSystem = unitSystem;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.putRequestParameter(LANG_PARAM, language.getValue());
        this.language = language;
    }

    public void setResponseType(ResponseType responseType) {
        this.putRequestParameter(MODE_PARAM, responseType.getValue());
    }

    public void putRequestParameter(String key, String value) {
        this.requestParameters.put(key, value);
    }

    public void removeRequestParameter(String key) {
        this.requestParameters.remove(key);
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void appendToURL(String appendix) {
        this.urlAppenderBuilder.append(appendix);
    }

    public StringBuilder getUrlAppender() {
        return this.urlAppenderBuilder;
    }
}

