/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.request.forecast.free;

import com.github.prominence.openweathermap.api.model.Coordinate;
import com.github.prominence.openweathermap.api.request.RequestSettings;
import com.github.prominence.openweathermap.api.request.forecast.free.FiveDayThreeHourStepForecastRequestCustomizer;

public class FiveDayThreeHourStepForecastRequester {
    private final RequestSettings requestSettings;

    public FiveDayThreeHourStepForecastRequester(RequestSettings requestSettings) {
        this.requestSettings = requestSettings;
        this.requestSettings.appendToURL("forecast");
    }

    public FiveDayThreeHourStepForecastRequestCustomizer byCityName(String cityName) {
        this.requestSettings.putRequestParameter("q", cityName);
        return new FiveDayThreeHourStepForecastRequestCustomizer(this.requestSettings);
    }

    public FiveDayThreeHourStepForecastRequestCustomizer byCityName(String cityName, String stateCode) {
        this.requestSettings.putRequestParameter("q", cityName + "," + stateCode);
        return new FiveDayThreeHourStepForecastRequestCustomizer(this.requestSettings);
    }

    public FiveDayThreeHourStepForecastRequestCustomizer byCityName(String cityName, String stateCode, String countryCode) {
        this.requestSettings.putRequestParameter("q", cityName + "," + stateCode + "," + countryCode);
        return new FiveDayThreeHourStepForecastRequestCustomizer(this.requestSettings);
    }

    public FiveDayThreeHourStepForecastRequestCustomizer byCityId(long cityId) {
        this.requestSettings.putRequestParameter("id", Long.toString(cityId));
        return new FiveDayThreeHourStepForecastRequestCustomizer(this.requestSettings);
    }

    public FiveDayThreeHourStepForecastRequestCustomizer byCoordinate(Coordinate coordinate) {
        this.requestSettings.putRequestParameter("lat", String.valueOf(coordinate.getLatitude()));
        this.requestSettings.putRequestParameter("lon", String.valueOf(coordinate.getLongitude()));
        return new FiveDayThreeHourStepForecastRequestCustomizer(this.requestSettings);
    }

    public FiveDayThreeHourStepForecastRequestCustomizer byZipCodeAndCountry(String zipCode, String countryCode) {
        this.requestSettings.putRequestParameter("zip", zipCode + "," + countryCode);
        return new FiveDayThreeHourStepForecastRequestCustomizer(this.requestSettings);
    }

    public FiveDayThreeHourStepForecastRequestCustomizer byZipCodeInUSA(String zipCode) {
        this.requestSettings.putRequestParameter("zip", zipCode);
        return new FiveDayThreeHourStepForecastRequestCustomizer(this.requestSettings);
    }
}

