/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.request.onecall.current;

import com.github.prominence.openweathermap.api.enums.Language;
import com.github.prominence.openweathermap.api.enums.OneCallResultOptions;
import com.github.prominence.openweathermap.api.enums.UnitSystem;
import com.github.prominence.openweathermap.api.request.RequestSettings;
import com.github.prominence.openweathermap.api.request.onecall.current.OneCallCurrentWeatherAsyncRequestTerminator;
import com.github.prominence.openweathermap.api.request.onecall.current.OneCallCurrentWeatherRequestTerminator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OneCallCurrentWeatherRequestCustomizer {
    private final RequestSettings requestSettings;

    OneCallCurrentWeatherRequestCustomizer(RequestSettings requestSettings) {
        this.requestSettings = requestSettings;
    }

    public OneCallCurrentWeatherRequestCustomizer language(Language language) {
        this.requestSettings.setLanguage(language);
        return this;
    }

    public OneCallCurrentWeatherRequestCustomizer unitSystem(UnitSystem unitSystem) {
        this.requestSettings.setUnitSystem(unitSystem);
        return this;
    }

    public OneCallCurrentWeatherRequestCustomizer exclude(OneCallResultOptions ... excludeOptions) {
        if (excludeOptions != null && excludeOptions.length > 0) {
            this.requestSettings.putRequestParameter("exclude", Stream.of(excludeOptions).map(OneCallResultOptions::getValue).collect(Collectors.joining(",")));
        } else {
            this.requestSettings.removeRequestParameter("exclude");
        }
        return this;
    }

    public OneCallCurrentWeatherRequestTerminator retrieve() {
        return new OneCallCurrentWeatherRequestTerminator(this.requestSettings);
    }

    public OneCallCurrentWeatherAsyncRequestTerminator retrieveAsync() {
        return new OneCallCurrentWeatherAsyncRequestTerminator(this.requestSettings);
    }
}

