/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.request.onecall.historical;

import com.github.prominence.openweathermap.api.mapper.OneCallWeatherResponseMapper;
import com.github.prominence.openweathermap.api.model.onecall.historical.HistoricalWeatherData;
import com.github.prominence.openweathermap.api.request.RequestSettings;
import com.github.prominence.openweathermap.api.utils.RequestUtils;
import java.util.concurrent.CompletableFuture;

public class OneCallHistoricalWeatherAsyncRequestTerminator {
    private final RequestSettings requestSettings;

    public OneCallHistoricalWeatherAsyncRequestTerminator(RequestSettings requestSettings) {
        this.requestSettings = requestSettings;
    }

    public CompletableFuture<HistoricalWeatherData> asJava() {
        return CompletableFuture.supplyAsync(() -> new OneCallWeatherResponseMapper(this.requestSettings.getUnitSystem()).mapToHistorical(this.getRawResponse()));
    }

    public CompletableFuture<String> asJSON() {
        return CompletableFuture.supplyAsync(this::getRawResponse);
    }

    private String getRawResponse() {
        return RequestUtils.getResponse(this.requestSettings);
    }
}

