/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.request.weather.multiple;

import com.github.prominence.openweathermap.api.model.Coordinate;
import com.github.prominence.openweathermap.api.model.CoordinateRectangle;
import com.github.prominence.openweathermap.api.request.RequestSettings;
import com.github.prominence.openweathermap.api.request.weather.multiple.MultipleResultCitiesInCircleCurrentWeatherRequestCustomizer;
import com.github.prominence.openweathermap.api.request.weather.multiple.MultipleResultCurrentWeatherRequestCustomizer;

public class MultipleLocationsCurrentWeatherRequester {
    private final RequestSettings requestSettings;

    public MultipleLocationsCurrentWeatherRequester(RequestSettings requestSettings) {
        this.requestSettings = requestSettings;
    }

    public MultipleResultCurrentWeatherRequestCustomizer byRectangle(CoordinateRectangle rectangle, int zoom) {
        String coordinates = rectangle.getFormattedRequestString() + "," + zoom;
        this.requestSettings.appendToURL("box/city");
        this.requestSettings.putRequestParameter("bbox", coordinates);
        return new MultipleResultCurrentWeatherRequestCustomizer(this.requestSettings);
    }

    public MultipleResultCitiesInCircleCurrentWeatherRequestCustomizer byCitiesInCycle(Coordinate point, int citiesCount) {
        this.requestSettings.appendToURL("find");
        this.requestSettings.putRequestParameter("lat", Double.toString(point.getLatitude()));
        this.requestSettings.putRequestParameter("lon", Double.toString(point.getLongitude()));
        this.requestSettings.putRequestParameter("cnt", Integer.toString(citiesCount));
        return new MultipleResultCitiesInCircleCurrentWeatherRequestCustomizer(this.requestSettings);
    }

    public MultipleResultCitiesInCircleCurrentWeatherRequestCustomizer byCitiesInCycle(Coordinate point) {
        this.requestSettings.appendToURL("find");
        this.requestSettings.putRequestParameter("lat", Double.toString(point.getLatitude()));
        this.requestSettings.putRequestParameter("lon", Double.toString(point.getLongitude()));
        return new MultipleResultCitiesInCircleCurrentWeatherRequestCustomizer(this.requestSettings);
    }
}

