/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.request.weather.single;

import com.github.prominence.openweathermap.api.model.Coordinate;
import com.github.prominence.openweathermap.api.request.RequestSettings;
import com.github.prominence.openweathermap.api.request.weather.single.SingleResultCurrentWeatherRequestCustomizer;

public class SingleLocationCurrentWeatherRequester {
    private final RequestSettings requestSettings;

    public SingleLocationCurrentWeatherRequester(RequestSettings requestSettings) {
        this.requestSettings = requestSettings;
        this.requestSettings.appendToURL("weather");
    }

    public SingleResultCurrentWeatherRequestCustomizer byCityName(String cityName) {
        this.requestSettings.putRequestParameter("q", cityName);
        return new SingleResultCurrentWeatherRequestCustomizer(this.requestSettings);
    }

    public SingleResultCurrentWeatherRequestCustomizer byCityName(String cityName, String countryCode) {
        this.requestSettings.putRequestParameter("q", cityName + "," + countryCode);
        return new SingleResultCurrentWeatherRequestCustomizer(this.requestSettings);
    }

    public SingleResultCurrentWeatherRequestCustomizer byCityName(String cityName, String stateCode, String countryCode) {
        this.requestSettings.putRequestParameter("q", cityName + "," + stateCode + "," + countryCode);
        return new SingleResultCurrentWeatherRequestCustomizer(this.requestSettings);
    }

    public SingleResultCurrentWeatherRequestCustomizer byCityId(long cityId) {
        this.requestSettings.putRequestParameter("id", String.valueOf(cityId));
        return new SingleResultCurrentWeatherRequestCustomizer(this.requestSettings);
    }

    public SingleResultCurrentWeatherRequestCustomizer byCoordinate(Coordinate coordinate) {
        this.requestSettings.putRequestParameter("lat", String.valueOf(coordinate.getLatitude()));
        this.requestSettings.putRequestParameter("lon", String.valueOf(coordinate.getLongitude()));
        return new SingleResultCurrentWeatherRequestCustomizer(this.requestSettings);
    }

    public SingleResultCurrentWeatherRequestCustomizer byZipCodeAndCountry(String zipCode, String countryCode) {
        this.requestSettings.putRequestParameter("zip", zipCode + "," + countryCode);
        return new SingleResultCurrentWeatherRequestCustomizer(this.requestSettings);
    }

    public SingleResultCurrentWeatherRequestCustomizer byZipCodeInUSA(String zipCode) {
        this.requestSettings.putRequestParameter("zip", zipCode);
        return new SingleResultCurrentWeatherRequestCustomizer(this.requestSettings);
    }
}

