/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.request.weather.single;

import com.github.prominence.openweathermap.api.enums.ResponseType;
import com.github.prominence.openweathermap.api.mapper.CurrentWeatherResponseMapper;
import com.github.prominence.openweathermap.api.model.weather.Weather;
import com.github.prominence.openweathermap.api.request.RequestSettings;
import com.github.prominence.openweathermap.api.utils.RequestUtils;
import java.util.concurrent.CompletableFuture;

public class SingleResultCurrentWeatherAsyncRequestTerminator {
    private final RequestSettings requestSettings;

    SingleResultCurrentWeatherAsyncRequestTerminator(RequestSettings requestSettings) {
        this.requestSettings = requestSettings;
    }

    public CompletableFuture<Weather> asJava() {
        return CompletableFuture.supplyAsync(() -> new CurrentWeatherResponseMapper(this.requestSettings.getUnitSystem()).getSingle(this.getRawResponse()));
    }

    public CompletableFuture<String> asJSON() {
        return CompletableFuture.supplyAsync(this::getRawResponse);
    }

    public CompletableFuture<String> asXML() {
        this.requestSettings.setResponseType(ResponseType.XML);
        return CompletableFuture.supplyAsync(this::getRawResponse);
    }

    public CompletableFuture<String> asHTML() {
        this.requestSettings.setResponseType(ResponseType.HTML);
        return CompletableFuture.supplyAsync(this::getRawResponse);
    }

    private String getRawResponse() {
        return RequestUtils.getResponse(this.requestSettings);
    }
}

