/*
 * Decompiled with CFR 0.152.
 */
package com.github.prominence.openweathermap.api.utils;

import com.github.prominence.openweathermap.api.conf.TimeoutSettings;
import com.github.prominence.openweathermap.api.exception.InvalidAuthTokenException;
import com.github.prominence.openweathermap.api.exception.NoDataFoundException;
import com.github.prominence.openweathermap.api.request.RequestSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtils {
    private static final String OWM_URL_BASE = "http://api.openweathermap.org/data/2.5/";
    private static final Logger logger = LoggerFactory.getLogger(RequestUtils.class);

    private RequestUtils() {
    }

    public static String getResponse(RequestSettings requestSettings) {
        StringBuilder requestUrlBuilder = new StringBuilder(OWM_URL_BASE);
        requestUrlBuilder.append((CharSequence)requestSettings.getUrlAppender());
        requestUrlBuilder.append('?');
        String parameters = requestSettings.getRequestParameters().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        requestUrlBuilder.append(parameters);
        return RequestUtils.getResponse(requestUrlBuilder.toString(), requestSettings.getTimeoutSettings());
    }

    public static String getResponse(String url) {
        return RequestUtils.getResponse(url, new TimeoutSettings());
    }

    public static String getResponse(String url, TimeoutSettings timeoutSettings) {
        URL requestUrl;
        try {
            requestUrl = new URL(url);
        }
        catch (MalformedURLException ex) {
            logger.error("Invalid URL: ", (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
        logger.debug("Executing OpenWeatherMap API request: " + url);
        InputStream requestInputStream = RequestUtils.executeRequest(requestUrl, timeoutSettings);
        return RequestUtils.convertInputStreamToString(requestInputStream);
    }

    private static InputStream executeRequest(URL requestUrl, TimeoutSettings timeoutSettings) {
        InputStream resultStream;
        try {
            HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
            if (timeoutSettings.getConnectionTimeout() != null) {
                connection.setConnectTimeout(timeoutSettings.getConnectionTimeout());
            }
            if (timeoutSettings.getReadTimeout() != null) {
                connection.setReadTimeout(timeoutSettings.getReadTimeout());
            }
            connection.setRequestMethod("GET");
            switch (connection.getResponseCode()) {
                case 200: {
                    resultStream = connection.getInputStream();
                    break;
                }
                case 401: {
                    throw new InvalidAuthTokenException();
                }
                case 400: 
                case 404: {
                    throw new NoDataFoundException();
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + connection.getResponseCode());
                }
            }
        }
        catch (IOException | IllegalStateException ex) {
            logger.error("An error occurred during OpenWeatherMap API response parsing: ", (Throwable)ex);
            throw new NoDataFoundException(ex);
        }
        return resultStream;
    }

    private static String convertInputStreamToString(InputStream inputStream) {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException ex) {
            logger.error("Error during response reading: ", (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
        return result.toString();
    }
}

