/*
 * Decompiled with CFR 0.152.
 */
package com.tjeannin.provigen;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.text.TextUtils;
import com.tjeannin.provigen.model.Contract;
import java.util.ArrayList;
import java.util.List;

public abstract class ProviGenProvider
extends ContentProvider {
    private List<Contract> contracts = new ArrayList<Contract>();
    private UriMatcher uriMatcher;
    private static final int ITEM = 1;
    private static final int ITEM_ID = 2;
    private SQLiteOpenHelper openHelper;

    public abstract SQLiteOpenHelper openHelper(Context var1);

    public abstract Class[] contractClasses();

    public boolean onCreate() {
        this.openHelper = this.openHelper(this.getContext());
        for (Class contract : this.contractClasses()) {
            this.contracts.add(new Contract(contract));
        }
        this.uriMatcher = new UriMatcher(-1);
        for (Contract contract : this.contracts) {
            this.uriMatcher.addURI(contract.getAuthority(), contract.getTable(), 1);
            this.uriMatcher.addURI(contract.getAuthority(), contract.getTable() + "/#", 2);
        }
        return true;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        SQLiteDatabase database = this.openHelper.getWritableDatabase();
        int numberOfRowsAffected = 0;
        Contract contract = this.findMatchingContract(uri);
        switch (this.uriMatcher.match(uri)) {
            case 1: {
                numberOfRowsAffected = database.delete(contract.getTable(), selection, selectionArgs);
                break;
            }
            case 2: {
                String itemId = String.valueOf(ContentUris.parseId((Uri)uri));
                if (TextUtils.isEmpty((CharSequence)selection)) {
                    numberOfRowsAffected = database.delete(contract.getTable(), contract.getIdField() + " = ? ", new String[]{itemId});
                    break;
                }
                numberOfRowsAffected = database.delete(contract.getTable(), selection + " AND " + contract.getIdField() + " = ? ", ProviGenProvider.appendToStringArray(selectionArgs, itemId));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown uri " + uri);
            }
        }
        this.getContext().getContentResolver().notifyChange(uri, null);
        return numberOfRowsAffected;
    }

    public String getType(Uri uri) {
        Contract contract = this.findMatchingContract(uri);
        switch (this.uriMatcher.match(uri)) {
            case 1: {
                return "vnd.android.cursor.dir/vdn." + contract.getTable();
            }
            case 2: {
                return "vnd.android.cursor.item/vdn." + contract.getTable();
            }
        }
        throw new IllegalArgumentException("Unknown uri " + uri);
    }

    public Uri insert(Uri uri, ContentValues values) {
        SQLiteDatabase database = this.openHelper.getWritableDatabase();
        Contract contract = this.findMatchingContract(uri);
        switch (this.uriMatcher.match(uri)) {
            case 1: {
                long itemId = database.insert(contract.getTable(), null, values);
                this.getContext().getContentResolver().notifyChange(uri, null);
                return Uri.withAppendedPath((Uri)uri, (String)String.valueOf(itemId));
            }
        }
        throw new IllegalArgumentException("Unknown uri " + uri);
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase database = this.openHelper.getReadableDatabase();
        Contract contract = this.findMatchingContract(uri);
        Cursor cursor = null;
        switch (this.uriMatcher.match(uri)) {
            case 1: {
                cursor = database.query(contract.getTable(), projection, selection, selectionArgs, "", "", sortOrder);
                break;
            }
            case 2: {
                String itemId = String.valueOf(ContentUris.parseId((Uri)uri));
                if (TextUtils.isEmpty((CharSequence)selection)) {
                    cursor = database.query(contract.getTable(), projection, contract.getIdField() + " = ? ", new String[]{itemId}, "", "", sortOrder);
                    break;
                }
                cursor = database.query(contract.getTable(), projection, selection + " AND " + contract.getIdField() + " = ? ", ProviGenProvider.appendToStringArray(selectionArgs, itemId), "", "", sortOrder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown uri " + uri);
            }
        }
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        SQLiteDatabase database = this.openHelper.getWritableDatabase();
        Contract contract = this.findMatchingContract(uri);
        int numberOfRowsAffected = 0;
        switch (this.uriMatcher.match(uri)) {
            case 1: {
                numberOfRowsAffected = database.update(contract.getTable(), values, selection, selectionArgs);
                break;
            }
            case 2: {
                String itemId = String.valueOf(ContentUris.parseId((Uri)uri));
                if (TextUtils.isEmpty((CharSequence)selection)) {
                    numberOfRowsAffected = database.update(contract.getTable(), values, contract.getIdField() + " = ? ", new String[]{itemId});
                    break;
                }
                numberOfRowsAffected = database.update(contract.getTable(), values, selection + " AND " + contract.getIdField() + " = ? ", ProviGenProvider.appendToStringArray(selectionArgs, itemId));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown uri " + uri);
            }
        }
        this.getContext().getContentResolver().notifyChange(uri, null);
        return numberOfRowsAffected;
    }

    public Contract findMatchingContract(Uri uri) {
        for (Contract contract : this.contracts) {
            if (!contract.getTable().equals(uri.getPathSegments().get(0))) continue;
            return contract;
        }
        return null;
    }

    private static String[] appendToStringArray(String[] array, String element) {
        if (array != null) {
            String[] newArray = new String[array.length + 1];
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[array.length] = element;
            return newArray;
        }
        return new String[]{element};
    }
}

