/*
 * Decompiled with CFR 0.152.
 */
package com.tjeannin.provigen.helper;

import android.database.sqlite.SQLiteDatabase;
import com.tjeannin.provigen.model.Constraint;
import com.tjeannin.provigen.model.Contract;
import com.tjeannin.provigen.model.ContractField;
import java.util.ArrayList;
import java.util.List;

public class TableBuilder {
    private Contract contract;
    private List<Constraint> constraints;

    public TableBuilder(Class contractClass) {
        this.contract = new Contract(contractClass);
        this.constraints = new ArrayList<Constraint>();
    }

    public TableBuilder addConstraint(String columnName, String constraintType, String constraintConflictClause) {
        this.constraints.add(new Constraint(columnName, constraintType, constraintConflictClause));
        return this;
    }

    public String getSQL() {
        StringBuilder builder = new StringBuilder("CREATE TABLE ");
        builder.append(this.contract.getTable()).append(" ( ");
        for (ContractField field : this.contract.getFields()) {
            builder.append(" ").append(field.name).append(" ").append(field.type);
            if (field.name.equals(this.contract.getIdField())) {
                builder.append(" PRIMARY KEY AUTOINCREMENT ");
            }
            for (Constraint constraint : this.constraints) {
                if (!constraint.targetColumn.equals(field.name)) continue;
                builder.append(" ").append(constraint.type).append(" ON CONFLICT ").append(constraint.conflictClause);
            }
            builder.append(", ");
        }
        builder.deleteCharAt(builder.length() - 2);
        builder.append(" ) ");
        return builder.toString();
    }

    public void createTable(SQLiteDatabase database) {
        database.execSQL(this.getSQL());
    }
}

