/*
 * Decompiled with CFR 0.152.
 */
package com.tjeannin.provigen.model;

import android.net.Uri;
import com.tjeannin.provigen.annotation.Column;
import com.tjeannin.provigen.annotation.ContentUri;
import com.tjeannin.provigen.annotation.Id;
import com.tjeannin.provigen.model.ContractField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class Contract {
    private String authority;
    private String idField;
    private String tableName;
    private List<ContractField> contractFields = new ArrayList<ContractField>();

    public Contract(Class contractClass) {
        Field[] fields;
        for (Field field : fields = contractClass.getFields()) {
            Column column;
            Id id;
            ContentUri contentUri = field.getAnnotation(ContentUri.class);
            if (contentUri != null) {
                try {
                    Uri uri = (Uri)field.get(null);
                    this.authority = uri.getAuthority();
                    this.tableName = uri.getLastPathSegment();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((id = field.getAnnotation(Id.class)) != null) {
                try {
                    this.idField = (String)field.get(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((column = field.getAnnotation(Column.class)) == null) continue;
            try {
                this.contractFields.add(new ContractField((String)field.get(null), column.value()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getIdField() {
        return this.idField;
    }

    public String getTable() {
        return this.tableName;
    }

    public List<ContractField> getFields() {
        return this.contractFields;
    }
}

