/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.filter._IIRFilter;

public class Butterworth
implements _IIRFilter {
    private double samplingFreq;

    public Butterworth(double Fs) {
        this.samplingFreq = Fs;
    }

    @Override
    public double[] lowPassFilter(double[] signal, int order, double cutoffFreq) {
        double[] output = new double[signal.length];
        uk.me.berndporr.iirj.Butterworth lp = new uk.me.berndporr.iirj.Butterworth();
        lp.lowPass(order, this.samplingFreq, cutoffFreq);
        for (int i = 0; i < output.length; ++i) {
            output[i] = lp.filter(signal[i]);
        }
        return output;
    }

    @Override
    public double[] highPassFilter(double[] signal, int order, double cutoffFreq) {
        double[] output = new double[signal.length];
        uk.me.berndporr.iirj.Butterworth hp = new uk.me.berndporr.iirj.Butterworth();
        hp.highPass(order, this.samplingFreq, cutoffFreq);
        for (int i = 0; i < output.length; ++i) {
            output[i] = hp.filter(signal[i]);
        }
        return output;
    }

    @Override
    public double[] bandPassFilter(double[] signal, int order, double lowCutoff, double highCutoff) throws IllegalArgumentException {
        if (lowCutoff >= highCutoff) {
            throw new IllegalArgumentException("Lower Cutoff Frequency cannot be more than the Higher Cutoff Frequency");
        }
        double centreFreq = (highCutoff + lowCutoff) / 2.0;
        double width = Math.abs(highCutoff - lowCutoff);
        double[] output = new double[signal.length];
        uk.me.berndporr.iirj.Butterworth bp = new uk.me.berndporr.iirj.Butterworth();
        bp.bandPass(order, this.samplingFreq, centreFreq, width);
        for (int i = 0; i < output.length; ++i) {
            output[i] = bp.filter(signal[i]);
        }
        return output;
    }

    @Override
    public double[] bandStopFilter(double[] signal, int order, double lowCutoff, double highCutoff) throws IllegalArgumentException {
        if (lowCutoff >= highCutoff) {
            throw new IllegalArgumentException("Lower Cutoff Frequency cannot be more than the Higher Cutoff Frequency");
        }
        double centreFreq = (highCutoff + lowCutoff) / 2.0;
        double width = Math.abs(highCutoff - lowCutoff);
        double[] output = new double[signal.length];
        uk.me.berndporr.iirj.Butterworth bs = new uk.me.berndporr.iirj.Butterworth();
        bs.bandStop(order, this.samplingFreq, centreFreq, width);
        for (int i = 0; i < output.length; ++i) {
            output[i] = bs.filter(signal[i]);
        }
        return output;
    }
}

