/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.filter._FIRFilter;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public class FIRLS
extends _FIRFilter {
    private double nyquistF;
    private int numTaps;

    public FIRLS(int numTaps, double samplingFreq) {
        if (numTaps % 2 == 0 || numTaps < 1) {
            throw new IllegalArgumentException("numTaps must be odd and greater than 0");
        }
        this.numTaps = numTaps;
        this.nyquistF = samplingFreq * 0.5;
    }

    public FIRLS(int numTaps) {
        if (numTaps % 2 == 0 || numTaps < 1) {
            throw new IllegalArgumentException("numTaps must be odd and greater than 0");
        }
        this.numTaps = numTaps;
        this.nyquistF = 1.0;
    }

    public double[] computeCoefficients(double[] cutoff, double[] gains, double[] weights) {
        int i;
        if (cutoff.length % 2 == 1) {
            throw new IllegalArgumentException("Cutoff must contain frequency pairs");
        }
        if (cutoff.length != gains.length) {
            throw new IllegalArgumentException("Cutoff length and gains length should be same");
        }
        if (weights.length != gains.length / 2) {
            throw new IllegalArgumentException("Weights length must be exactly half of the cutoff length");
        }
        for (double v : cutoff) {
            if (!(v < 0.0)) continue;
            throw new IllegalArgumentException("Cutoff frequencies cannot be negative");
        }
        for (double v : weights) {
            if (!(v < 0.0)) continue;
            throw new IllegalArgumentException("Weights must be non-negative");
        }
        if (!UtilMethods.isSorted(cutoff, false)) {
            throw new IllegalArgumentException("Cutoff frequencies must be non-decreasing");
        }
        Double[] arr = new Double[cutoff.length];
        for (int i2 = 0; i2 < cutoff.length; ++i2) {
            arr[i2] = cutoff[i2];
        }
        HashSet<Double> targetSet = new HashSet<Double>(Arrays.asList(arr));
        if (arr.length != targetSet.size()) {
            throw new IllegalArgumentException("Cutoff array cannot have any duplicates");
        }
        if (arr[0] != 0.0 || arr[arr.length - 1] != this.nyquistF) {
            throw new IllegalArgumentException("Cutoff must start with 0 and end with the Nyquist frequency");
        }
        int semi_cutoff = cutoff.length / 2;
        RealMatrix bands = MatrixUtils.createRealMatrix((int)semi_cutoff, (int)2);
        RealMatrix desired = MatrixUtils.createRealMatrix((int)semi_cutoff, (int)2);
        RealMatrix w = MatrixUtils.createRealMatrix((int)semi_cutoff, (int)1);
        int index_cutoff = 0;
        int index_gains = 0;
        for (int i3 = 0; i3 < semi_cutoff; ++i3) {
            bands.addToEntry(i3, 0, cutoff[index_cutoff++]);
            bands.addToEntry(i3, 1, cutoff[index_cutoff++]);
            desired.addToEntry(i3, 0, gains[index_gains++]);
            desired.addToEntry(i3, 1, gains[index_gains++]);
            w.addToEntry(i3, 0, weights[i3]);
        }
        bands = bands.scalarMultiply(1.0 / this.nyquistF);
        double[] n = UtilMethods.arange(0.0, (double)this.numTaps, 1.0);
        RealMatrix[] holder = new RealMatrix[this.numTaps];
        RealMatrix q = MatrixUtils.createRealMatrix((int)this.numTaps, (int)semi_cutoff);
        RealMatrix qout = MatrixUtils.createRealMatrix((int)this.numTaps, (int)1);
        for (int i4 = 0; i4 < this.numTaps; ++i4) {
            holder[i4] = bands.scalarMultiply(n[i4]);
            holder[i4].walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

                public double visit(int row, int column, double value) {
                    return UtilMethods.sinc(value);
                }
            });
            holder[i4] = UtilMethods.ebeMultiply(holder[i4], bands);
            for (int row = 0; row < semi_cutoff; ++row) {
                q.setEntry(i4, row, holder[i4].getEntry(row, 1) - holder[i4].getEntry(row, 0));
            }
        }
        qout = q.multiply(w);
        double[] q_double = new double[qout.getRowDimension()];
        for (int i5 = 0; i5 < q_double.length; ++i5) {
            q_double[i5] = qout.getEntry(i5, 0);
        }
        int M = (this.numTaps - 1) / 2;
        double[] temp1 = UtilMethods.splitByIndex(q_double, 0, M + 1);
        double[] temp2 = UtilMethods.splitByIndex(q_double, M, q_double.length);
        RealMatrix Q1 = MatrixUtils.createRealMatrix((double[][])UtilMethods.toeplitz(temp1));
        RealMatrix Q2 = MatrixUtils.createRealMatrix((double[][])UtilMethods.hankel(temp1, temp2));
        RealMatrix Q = Q1.add(Q2);
        RealMatrix bands_diff = MatrixUtils.createRealMatrix((int)semi_cutoff, (int)1);
        for (int i6 = 0; i6 < semi_cutoff; ++i6) {
            bands_diff.setEntry(i6, 0, bands.getEntry(i6, 1) - bands.getEntry(i6, 0));
        }
        RealMatrix desired_diff = MatrixUtils.createRealMatrix((int)semi_cutoff, (int)1);
        for (int i7 = 0; i7 < semi_cutoff; ++i7) {
            desired_diff.setEntry(i7, 0, desired.getEntry(i7, 1) - desired.getEntry(i7, 0));
        }
        n = UtilMethods.splitByIndex(n, 0, M + 1);
        int short_n = n.length;
        RealMatrix m = UtilMethods.ebeDivide(desired_diff, bands_diff);
        RealMatrix band0 = bands.getSubMatrix(0, bands.getRowDimension() - 1, 0, 0);
        RealMatrix desired0 = desired.getSubMatrix(0, desired.getRowDimension() - 1, 0, 0);
        RealMatrix c = desired0.subtract(UtilMethods.ebeMultiply(band0, m));
        holder = new RealMatrix[short_n];
        RealMatrix b = MatrixUtils.createRealMatrix((int)short_n, (int)semi_cutoff);
        for (int i8 = 0; i8 < short_n; ++i8) {
            RealMatrix temp;
            holder[i8] = bands.scalarMultiply(n[i8]);
            holder[i8].walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

                public double visit(int row, int column, double value) {
                    return UtilMethods.sinc(value);
                }
            });
            holder[i8] = UtilMethods.ebeMultiply(holder[i8], bands);
            RealMatrix mbc = UtilMethods.ebeMultiply(bands, m, "column");
            mbc = UtilMethods.ebeAdd(mbc, c, "column");
            holder[i8] = UtilMethods.ebeMultiply(holder[i8], mbc);
            if (i8 == 0) {
                temp = UtilMethods.ebeMultiply(bands, bands);
                temp = UtilMethods.ebeMultiply(temp, m, "column");
                temp = temp.scalarMultiply(0.5);
                holder[i8] = UtilMethods.ebeSubtract(holder[i8], temp);
            } else {
                temp = bands.scalarMultiply(Math.PI * n[i8]);
                temp = UtilMethods.ebeMultiply(temp, m, "column");
                temp = temp.scalarMultiply(Math.pow(n[i8] * Math.PI, 2.0));
                holder[i8] = UtilMethods.ebeSubtract(holder[i8], temp);
            }
            for (int row = 0; row < semi_cutoff; ++row) {
                b.setEntry(i8, row, holder[i8].getEntry(row, 1) - holder[i8].getEntry(row, 0));
            }
        }
        b = b.multiply(w);
        RealVector b_final = b.getColumnVector(0);
        DecompositionSolver solver = new SingularValueDecomposition(Q).getSolver();
        RealVector solution = solver.solve(b_final);
        double[] a = solution.toArray();
        double[] out = new double[(a.length - 1) * 2 + 1];
        int index = 0;
        for (i = a.length - 1; i >= 1; --i) {
            out[index++] = a[i];
        }
        out[index++] = a[0] * 2.0;
        for (i = 1; i < a.length; ++i) {
            out[index++] = a[i];
        }
        return out;
    }

    public double[] computeCoefficients(double[] cutoff, double[] gains) {
        double[] weights = new double[cutoff.length / 2];
        Arrays.fill(weights, 1.0);
        return this.computeCoefficients(cutoff, gains, weights);
    }
}

