/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.filter._FIRFilter;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.windows.Kaiser;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.MathArrays;

public class FIRWin1
extends _FIRFilter {
    private double attenuation;
    private double beta;
    private int numTaps;
    private double width;
    private double nyquistF;

    public FIRWin1(int numTaps, double width, double samplingFreq) {
        this.nyquistF = samplingFreq * 0.5;
        this.numTaps = numTaps;
        this.width = width / this.nyquistF;
        this.kaiserAttenutation();
        this.kaiserBeta();
    }

    public FIRWin1(double ripple, double width, double samplingFreq) {
        this.nyquistF = samplingFreq * 0.5;
        this.width = width / this.nyquistF;
        this.kaiserOrder(ripple, this.width);
    }

    public FIRWin1(int numTaps, double width) {
        this.nyquistF = 1.0;
        this.numTaps = numTaps;
        this.width = width;
        this.kaiserAttenutation();
        this.kaiserBeta();
    }

    public FIRWin1(int numTaps, double beta, boolean direct_kaiser) {
        this.nyquistF = 1.0;
        this.numTaps = numTaps;
        this.beta = beta;
    }

    public FIRWin1(double ripple, double width) {
        this.nyquistF = 1.0;
        this.width = width;
        this.kaiserOrder(ripple, this.width);
    }

    private void kaiserBeta() {
        this.beta = this.attenuation > 50.0 ? 0.1102 * (this.attenuation - 8.7) : (this.attenuation > 21.0 ? 0.5842 * Math.pow(this.attenuation - 21.0, 0.4) + 0.07886 * (this.attenuation - 21.0) : 0.0);
    }

    private void kaiserAttenutation() {
        this.attenuation = 2.285 * (double)(this.numTaps - 1) * Math.PI * (double)((float)this.width) + 7.95;
    }

    public void kaiserOrder(double ripple, double width) {
        this.attenuation = Math.abs(ripple);
        if (this.attenuation < 8.0) {
            throw new IllegalArgumentException("Maximum ripple attenuation too small for Kaiser function");
        }
        this.width = width;
        this.kaiserBeta();
        this.numTaps = (int)Math.ceil((this.attenuation - 7.95) / 2.285 / (Math.PI * this.width) + 1.0);
    }

    public double[] computeCoefficients(double[] cutoff, FIRfilterType filterType, boolean scale) {
        boolean passZero;
        for (int i = 0; i < cutoff.length; ++i) {
            cutoff[i] = cutoff[i] / this.nyquistF;
            if (!(cutoff[i] >= 1.0) && !(cutoff[i] <= 0.0)) continue;
            throw new IllegalArgumentException("Invalid cutoff frequency: must be greater than 0 and less than Nyquist frequency");
        }
        double[] difference = UtilMethods.diff(cutoff);
        if (StatUtils.min((double[])difference) <= 0.0) {
            throw new IllegalArgumentException("Invalid cutoff frequency: must be strictly increasing");
        }
        Kaiser w = new Kaiser(this.numTaps, this.beta);
        double[] window = w.getWindow();
        switch (filterType.ordinal()) {
            case 0: {
                if (cutoff.length < 1) {
                    throw new IllegalArgumentException("For lowpass, cutoff must have only one frequency");
                }
                passZero = true;
                break;
            }
            case 1: {
                if (cutoff.length < 2) {
                    throw new IllegalArgumentException("For bandstop, cutoff must have at least two frequencies");
                }
                passZero = true;
                break;
            }
            case 2: {
                if (cutoff.length < 3) {
                    throw new IllegalArgumentException("For multibandstop, cutoff must have at least three frequencies");
                }
                passZero = true;
                break;
            }
            case 3: {
                if (cutoff.length < 1) {
                    throw new IllegalArgumentException("For highpass, cutoff must have only one frequency");
                }
                passZero = false;
                break;
            }
            case 4: {
                if (cutoff.length < 2) {
                    throw new IllegalArgumentException("For bandpass, cutoff must have at least two frequencies");
                }
                passZero = false;
                break;
            }
            case 5: {
                if (cutoff.length < 3) {
                    throw new IllegalArgumentException("For multibandpass, cutoff must have at least three frequencies");
                }
                passZero = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown filter type");
            }
        }
        boolean passNyquist = (cutoff.length & 1) == 1 ^ passZero;
        if (passNyquist && this.numTaps % 2 == 0) {
            throw new ArithmeticException("A filter with an even number of coefficients must have zero response at the Nyquist frequency");
        }
        if (passZero) {
            cutoff = UtilMethods.concatenateArray(new double[]{0.0}, cutoff);
        }
        if (passNyquist) {
            cutoff = UtilMethods.concatenateArray(cutoff, new double[]{1.0});
        }
        double alpha = 0.5 * (double)(this.numTaps - 1);
        double[] m = UtilMethods.arange(0.0, (double)this.numTaps, 1.0);
        m = UtilMethods.scalarArithmetic(m, alpha, "sub");
        double[] h = new double[this.numTaps];
        Arrays.fill(h, 0.0);
        for (int i = 0; i < cutoff.length; i += 2) {
            double left = cutoff[i];
            double right = cutoff[i + 1];
            double[] temp_right = UtilMethods.sinc(UtilMethods.scalarArithmetic(m, right, "mul"));
            temp_right = UtilMethods.scalarArithmetic(temp_right, right, "mul");
            double[] temp_left = UtilMethods.sinc(UtilMethods.scalarArithmetic(m, left, "mul"));
            temp_left = UtilMethods.scalarArithmetic(temp_left, left, "mul");
            h = MathArrays.ebeAdd((double[])h, (double[])temp_right);
            h = MathArrays.ebeSubtract((double[])h, (double[])temp_left);
        }
        h = MathArrays.ebeMultiply((double[])h, (double[])window);
        if (scale) {
            double left = cutoff[0];
            double right = cutoff[1];
            double scaleFreq = left == 0.0 ? 0.0 : (right == 1.0 ? 1.0 : 0.5 * (left + right));
            scaleFreq = Math.PI * scaleFreq;
            double[] c = UtilMethods.scalarArithmetic(m, scaleFreq, "mul");
            c = UtilMethods.trigonometricArithmetic(c, "cos");
            double s = Arrays.stream(MathArrays.ebeMultiply((double[])h, (double[])c)).sum();
            h = UtilMethods.scalarArithmetic(h, s, "div");
        }
        return h;
    }

    public static enum FIRfilterType {
        LOWPASS,
        BANDSTOP,
        MULTIBANDSTOP,
        HIGHPASS,
        BANDPASS,
        MULTIBANDPASS;

    }
}

