/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.filter._FIRFilter;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.transform.InverseDiscreteFourier;
import com.github.psambit9791.jdsp.windows.Hamming;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.util.MathArrays;

public class FIRWin2
extends _FIRFilter {
    private double nyquistF;
    private int numTaps;
    private boolean antisymmetric;
    private int ftype;

    public FIRWin2(int numTaps, double samplingFreq, boolean antisymmetric) {
        this.nyquistF = samplingFreq * 0.5;
        this.numTaps = numTaps;
        this.antisymmetric = antisymmetric;
        this.ftype = !this.antisymmetric ? (this.numTaps % 2 == 0 ? 2 : 1) : (this.numTaps % 2 == 0 ? 4 : 3);
    }

    public FIRWin2(int numTaps, boolean antisymmetric) {
        this.nyquistF = 1.0;
        this.numTaps = numTaps;
        this.antisymmetric = antisymmetric;
        this.ftype = !this.antisymmetric ? (this.numTaps % 2 == 0 ? 2 : 1) : (this.numTaps % 2 == 0 ? 4 : 3);
    }

    public FIRWin2(int numTaps, double samplingFreq) {
        this.nyquistF = samplingFreq * 0.5;
        this.numTaps = numTaps;
        this.antisymmetric = false;
        this.ftype = this.numTaps % 2 == 0 ? 2 : 1;
    }

    public FIRWin2(int numTaps) {
        this.nyquistF = 1.0;
        this.numTaps = numTaps;
        this.antisymmetric = false;
        this.ftype = this.numTaps % 2 == 0 ? 2 : 1;
    }

    public int getFilterType() {
        return this.ftype;
    }

    public double[] computeCoefficients(double[] cutoff, double[] gain) {
        if (cutoff.length != gain.length) {
            throw new IllegalArgumentException("Size of cutoff array and gain array must be same.");
        }
        if (!UtilMethods.isSorted(cutoff, false)) {
            throw new IllegalArgumentException("Cutoff frequencies must be non-decreasing");
        }
        for (double v : cutoff) {
            if (!(v < 0.0)) continue;
            throw new IllegalArgumentException("Cutoff frequencies cannot be negative");
        }
        Double[] arr = new Double[cutoff.length];
        for (int i = 0; i < cutoff.length; ++i) {
            arr[i] = cutoff[i];
        }
        HashSet<Double> targetSet = new HashSet<Double>(Arrays.asList(arr));
        if (arr.length != targetSet.size()) {
            throw new IllegalArgumentException("Cutoff array cannot have any duplicates");
        }
        if (arr[0] != 0.0 || arr[arr.length - 1] != this.nyquistF) {
            throw new IllegalArgumentException("Cutoff must start with 0 and end with the Nyquist frequency");
        }
        int base = 2;
        int log_val = (int)Math.ceil(UtilMethods.log(this.numTaps, base));
        int nfreqs = (int)(UtilMethods.antilog(log_val, base) + 1.0);
        double[] x = UtilMethods.linspace(0.0, this.nyquistF, nfreqs, true);
        double[] fx = UtilMethods.interpolate(x, cutoff, gain);
        Complex shift_const = new Complex(0.0, -((double)(this.numTaps - 1) / 2.0 * Math.PI) / this.nyquistF);
        Complex factor = new Complex(0.0, 1.0);
        Complex[] fx2 = new Complex[fx.length];
        for (int i = 0; i < fx2.length; ++i) {
            Complex shift = shift_const.multiply(x[i]);
            shift = shift.exp();
            if (this.ftype > 2) {
                shift = shift.multiply(factor);
            }
            fx2[i] = shift.multiply(fx[i]);
        }
        double[][] fx2D = UtilMethods.complexTo2D(fx2);
        InverseDiscreteFourier transform = new InverseDiscreteFourier(fx2D, true);
        transform.transform();
        double[] outFull = transform.getReal();
        Hamming w = new Hamming(this.numTaps);
        double[] window = w.getWindow();
        double[] out = UtilMethods.splitByIndex(outFull, 0, this.numTaps);
        out = MathArrays.ebeMultiply((double[])out, (double[])window);
        if (this.ftype == 3) {
            out[out.length / 2] = 0.0;
        }
        return out;
    }
}

