/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.filter._KernelFilter;
import com.github.psambit9791.jdsp.misc.Polynomial;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import com.github.psambit9791.jdsp.signal.Convolution;
import java.util.Arrays;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class Savgol
implements _KernelFilter {
    private int windowSize;
    private int polyOrder;
    private double[] output;
    private int deriv;
    private double delta;
    private double[] coeffs;

    public Savgol(int windowSize, int polynomialOrder) {
        if (polynomialOrder >= windowSize) {
            throw new IllegalArgumentException("polynomialOrder must be less that windowSize");
        }
        this.windowSize = windowSize;
        this.polyOrder = polynomialOrder;
        this.deriv = 0;
        this.delta = 1.0;
    }

    public Savgol(int windowSize, int polynomialOrder, int deriv, double delta) {
        if (polynomialOrder >= windowSize) {
            throw new IllegalArgumentException("polynomialOrder must be less that windowSize");
        }
        this.windowSize = windowSize;
        this.polyOrder = polynomialOrder;
        this.deriv = deriv;
        this.delta = delta;
    }

    private void fitEdge(double[] signal, double[] output, int windowStart, int windowStop, int interpStart, int interpStop) {
        double[] xEdge = UtilMethods.splitByIndex(signal, windowStart, windowStop);
        double[] polyCoeffs = Polynomial.polyfit(UtilMethods.arange(0.0, (double)(windowStop - windowStart), 1.0), xEdge, this.polyOrder);
        if (this.deriv > 0) {
            polyCoeffs = Polynomial.polyder(polyCoeffs, this.deriv);
        }
        double[] i = UtilMethods.arange((double)(interpStart - windowStart), (double)(interpStop - windowStart), 1.0);
        double[] values = Polynomial.polyval(polyCoeffs, i);
        double divisor = Math.pow(this.delta, this.deriv);
        for (int k = 0; k < values.length; ++k) {
            values[k] = values[k] / divisor;
        }
        System.arraycopy(values, 0, this.output, interpStart, values.length);
    }

    private void fitEdgePolyfit(double[] signal, int windowLength) {
        int halflen = windowLength / 2;
        int n = signal.length;
        this.fitEdge(signal, this.output, 0, windowLength, 0, halflen);
        this.fitEdge(signal, this.output, n - windowLength, n, n - halflen, n);
    }

    public double[] savgolCoeffs() throws IllegalArgumentException {
        int halflen = this.windowSize / 2;
        int rem = this.windowSize % 2;
        if (rem == 0) {
            throw new IllegalArgumentException("windowSize must be odd");
        }
        double pos = halflen;
        double[] x = UtilMethods.arange(-pos, (double)this.windowSize - pos, 1.0);
        x = UtilMethods.reverse(x);
        int[] order = UtilMethods.arange(0, this.polyOrder + 1, 1);
        double[][] A = new double[order.length][x.length];
        for (int i = 0; i < order.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                A[i][j] = Math.pow(x[j], order[i]);
            }
        }
        double[] y = new double[order.length];
        Arrays.fill(y, 0.0);
        y[this.deriv] = (double)CombinatoricsUtils.factorial((int)this.deriv) / Math.pow(this.delta, this.deriv);
        A = UtilMethods.pseudoInverse(A);
        this.coeffs = MatrixUtils.createRealMatrix((double[][])A).operate(y);
        return this.coeffs;
    }

    @Override
    public double[] filter(double[] signal) {
        this.savgolCoeffs();
        Convolution c = new Convolution(signal, this.coeffs);
        if (this.windowSize > signal.length) {
            throw new IllegalArgumentException("For interp mode, window size should be less than signal size");
        }
        this.output = c.convolve1d("constant");
        this.fitEdgePolyfit(signal, this.windowSize);
        return this.output;
    }

    public double[] filter(double[] signal, String mode) throws IllegalArgumentException {
        if (!(mode.equals("nearest") || mode.equals("constant") || mode.equals("mirror") || mode.equals("wrap") || mode.equals("interp"))) {
            throw new IllegalArgumentException("mode must be mirror, constant, nearest, wrap or interp");
        }
        this.savgolCoeffs();
        Convolution c = new Convolution(signal, this.coeffs);
        if (mode.equals("interp")) {
            if (this.windowSize > signal.length) {
                throw new IllegalArgumentException("For interp mode, window size should be less than signal size");
            }
            this.output = c.convolve1d("constant");
            this.fitEdgePolyfit(signal, this.windowSize);
        } else {
            this.output = c.convolve1d(mode);
        }
        return this.output;
    }
}

