/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter;

import com.github.psambit9791.jdsp.filter._KernelFilter;
import com.github.psambit9791.jdsp.signal.Convolution;
import com.github.psambit9791.jdsp.signal.CrossCorrelation;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.util.MathArrays;

public class Wiener
implements _KernelFilter {
    private int windowSize;

    public Wiener() throws IllegalArgumentException {
        this.windowSize = 3;
    }

    public Wiener(int wsize) throws IllegalArgumentException {
        this.windowSize = wsize;
    }

    @Override
    public double[] filter(double[] signal) {
        if (this.windowSize >= signal.length) {
            throw new IllegalArgumentException("Signal Length has to be greater than 3.");
        }
        double[] cons = new double[this.windowSize];
        Arrays.fill(cons, 1.0);
        Convolution c1 = new Convolution(signal, cons);
        double[] localMean = c1.fastConvolve("same");
        localMean = MathArrays.scale((double)(1.0 / (double)this.windowSize), (double[])localMean);
        double[] signalSquare = MathArrays.ebeMultiply((double[])signal, (double[])signal);
        double[] meanSquare = MathArrays.ebeMultiply((double[])localMean, (double[])localMean);
        CrossCorrelation c2 = new CrossCorrelation(signalSquare, cons);
        double[] localVariance = c2.crossCorrelate("same");
        localVariance = MathArrays.scale((double)(1.0 / (double)this.windowSize), (double[])localVariance);
        localVariance = MathArrays.ebeSubtract((double[])localVariance, (double[])meanSquare);
        double noiseMean = StatUtils.mean((double[])localVariance);
        double[] res = MathArrays.ebeSubtract((double[])signal, (double[])localMean);
        double[] temp = new double[localVariance.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = 1.0 - noiseMean / localVariance[i];
        }
        res = MathArrays.ebeMultiply((double[])res, (double[])temp);
        res = MathArrays.ebeAdd((double[])res, (double[])localMean);
        double[] out = new double[localVariance.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = localVariance[i] < noiseMean ? localMean[i] : res[i];
        }
        return out;
    }
}

