/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter.adaptive;

import com.github.psambit9791.jdsp.filter.adaptive._Adaptive;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.Arrays;

public class GNGD
implements _Adaptive {
    private double[] weights;
    private double[] error;
    private double[] output;
    private double mu;
    private double ro;
    private double eps;
    private double last_e;
    private double[] last_x;

    public GNGD(double learningRate, double eps, double ro, double[] weights) {
        if (weights == null || weights.length == 0) {
            throw new IllegalArgumentException("Weights must be non-null and with a length greater than 0");
        }
        this.weights = weights;
        this.mu = learningRate;
        this.ro = ro;
        this.eps = eps;
        int length = weights.length;
        this.last_e = 0.0;
        this.last_x = new double[length];
        Arrays.fill(this.last_x, 0.0);
    }

    public GNGD(double[] weights) {
        this(1.0, 1.0, 0.1, weights);
    }

    public GNGD(int length, double learningRate, double eps, double ro, _Adaptive.WeightsFillMethod fillMethod) {
        this.weights = new double[length];
        this.mu = learningRate;
        this.eps = eps;
        this.ro = ro;
        switch (fillMethod) {
            case RANDOM: {
                for (int i = 0; i < length; ++i) {
                    this.weights[i] = Math.random();
                }
                break;
            }
            case ZEROS: {
                Arrays.fill(this.weights, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown weights fill method");
            }
        }
        this.last_e = 0.0;
        this.last_x = new double[length];
        Arrays.fill(this.last_x, 0.0);
    }

    public GNGD(int length, _Adaptive.WeightsFillMethod fillMethod) {
        this(length, 1.0, 1.0, 0.1, fillMethod);
    }

    private double[] adaptWeights(double desired, double[] x) {
        double y = UtilMethods.dotProduct(x, this.weights);
        double error = desired - y;
        double temp = UtilMethods.dotProduct(x, this.last_x) / Math.pow(UtilMethods.dotProduct(this.last_x, this.last_x) + this.eps, 2.0);
        temp = this.ro * this.mu * error * this.last_e * temp;
        this.eps -= temp;
        double nu = this.mu / (UtilMethods.dotProduct(x, x) + this.eps);
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = this.weights[i] + nu * error * x[i];
        }
        this.last_e = error;
        return new double[]{y, error};
    }

    @Override
    public void filter(double[] desired, double[] x) {
        if (desired == null || desired.length == 0) {
            throw new IllegalArgumentException("Desired signal cannot be null, or with size 0");
        }
        if (x == null || x.length == 0) {
            throw new IllegalArgumentException("Input signal cannot be null, or with size 0");
        }
        if (x.length != desired.length) {
            throw new IllegalArgumentException("The length of the desired signal and input signal must be equal.");
        }
        if (this.weights.length > x.length) {
            throw new IllegalArgumentException("Filter length must not be greater than the signal length");
        }
        this.error = new double[x.length];
        this.output = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            double[] x_subset = new double[this.weights.length];
            Arrays.fill(x_subset, 0.0);
            for (int j = 0; j < x_subset.length; ++j) {
                if (i - j <= 0) continue;
                x_subset[x_subset.length - 1 - j] = x[i - j];
            }
            double[] out = this.adaptWeights(desired[i], x_subset);
            this.output[i] = out[0];
            this.error[i] = out[1];
        }
    }

    public double[] getWeights() {
        this.checkOutput();
        return this.weights;
    }

    public double[] getError() {
        this.checkOutput();
        return this.error;
    }

    public double[] getOutput() {
        this.checkOutput();
        return this.output;
    }

    private void checkOutput() {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute filter() function before returning result");
        }
    }
}

