/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.filter.adaptive;

import com.github.psambit9791.jdsp.filter.adaptive._Adaptive;
import com.github.psambit9791.jdsp.misc.UtilMethods;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;

public class NSSLMS
implements _Adaptive {
    private final double learningRate;
    private final double leakageFactor;
    private double[] weights;
    private double[] error;
    private double[] output;

    private double sign(double err) {
        double val = 0.0;
        val = err < 0.0 ? -1.0 : (err == 0.0 ? 0.0 : 1.0);
        return val;
    }

    public NSSLMS(double learningRate, double leakageFactor, double[] weights) {
        if (weights == null || weights.length == 0) {
            throw new IllegalArgumentException("Weights must be non-null and with a length greater than 0");
        }
        if (learningRate < 0.0 || learningRate > 2.0) {
            System.err.println("Keep the learning rate between 0 and 2 to avoid diverging results");
        }
        this.learningRate = learningRate;
        this.leakageFactor = leakageFactor;
        this.weights = weights;
    }

    public NSSLMS(double learningRate, double[] weights) {
        this(learningRate, 1.0, weights);
    }

    public NSSLMS(double learningRate, double leakageFactor, int length, _Adaptive.WeightsFillMethod fillMethod) {
        if (learningRate < 0.0 || learningRate > 2.0) {
            System.err.println("Keep the learning rate between 0 and 2 to avoid diverging results");
        }
        this.learningRate = learningRate;
        this.leakageFactor = leakageFactor;
        this.weights = new double[length];
        switch (fillMethod) {
            case RANDOM: {
                for (int i = 0; i < length; ++i) {
                    this.weights[i] = Math.random();
                }
                break;
            }
            case ZEROS: {
                Arrays.fill(this.weights, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown weights fill method");
            }
        }
    }

    public NSSLMS(double learningRate, int length, _Adaptive.WeightsFillMethod fillMethod) {
        this(learningRate, 1.0, length, fillMethod);
    }

    private double[] adaptWeights(double desired, double[] x) {
        double regTerm = 2.220446049250313E-16;
        double y = UtilMethods.dotProduct(this.weights, x);
        double power_x = StatUtils.sum((double[])UtilMethods.scalarArithmetic(x, 2.0, "pow"));
        double error = desired - y;
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = this.leakageFactor * this.weights[i] + this.learningRate / (regTerm + power_x) * this.sign(error) * this.sign(x[i]);
        }
        return new double[]{y, error};
    }

    @Override
    public void filter(double[] desired, double[] x) {
        if (desired == null || desired.length == 0) {
            throw new IllegalArgumentException("Desired signal cannot be null, or with size 0");
        }
        if (x == null || x.length == 0) {
            throw new IllegalArgumentException("Input signal cannot be null, or with size 0");
        }
        if (x.length != desired.length) {
            throw new IllegalArgumentException("The length of the desired signal and input signal must be equal.");
        }
        if (this.weights.length > x.length) {
            throw new IllegalArgumentException("Filter length must not be greater than the signal length");
        }
        this.error = new double[x.length];
        this.output = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            double[] x_subset = new double[this.weights.length];
            Arrays.fill(x_subset, 0.0);
            for (int j = 0; j < x_subset.length; ++j) {
                if (i - j <= 0) continue;
                x_subset[x_subset.length - 1 - j] = x[i - j];
            }
            double[] out = this.adaptWeights(desired[i], x_subset);
            this.output[i] = out[0];
            this.error[i] = out[1];
        }
    }

    public double[] getWeights() {
        this.checkOutput();
        return this.weights;
    }

    public double[] getError() {
        this.checkOutput();
        return this.error;
    }

    public double[] getOutput() {
        this.checkOutput();
        return this.output;
    }

    private void checkOutput() {
        if (this.output == null) {
            throw new ExceptionInInitializerError("Execute filter() function before returning result");
        }
    }
}

