/*
 * Decompiled with CFR 0.152.
 */
package com.github.psambit9791.jdsp.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class CSV {
    private HashMap<String, ArrayList<Object>> content = new HashMap();
    private String sep;
    private String[] keyList;

    public CSV(char separator) {
        this.sep = separator + "";
    }

    private void initialiseHashMap(String[] colNames) {
        this.keyList = colNames;
        for (int i = 0; i < this.keyList.length; ++i) {
            this.content.put(this.keyList[i], new ArrayList());
        }
    }

    private void addRecordToHashmap(String[] data) {
        for (int i = 0; i < this.keyList.length; ++i) {
            this.content.get(this.keyList[i]).add(data[i]);
        }
    }

    public HashMap<String, ArrayList<Object>> readCSV(String pathToCsv, String[] colNames, boolean hasColNames) throws IOException {
        BufferedReader csvReader = new BufferedReader(new FileReader(pathToCsv));
        if (hasColNames) {
            csvReader.readLine();
        }
        String row = "";
        this.initialiseHashMap(colNames);
        while ((row = csvReader.readLine()) != null) {
            String[] data = row.split(this.sep);
            this.addRecordToHashmap(data);
        }
        return this.content;
    }

    public HashMap<String, ArrayList<Object>> readCSV(String pathToCsv, boolean hasColNames) throws IOException {
        BufferedReader csvReader = new BufferedReader(new FileReader(pathToCsv));
        if (!hasColNames) {
            BufferedReader test = new BufferedReader(new FileReader(pathToCsv));
            int totalCols = test.readLine().split(this.sep).length;
            String[] colNames = new String[totalCols];
            for (int i = 0; i < totalCols; ++i) {
                colNames[i] = "X" + i;
            }
            this.initialiseHashMap(colNames);
        } else {
            String[] colNames = csvReader.readLine().split(this.sep);
            this.initialiseHashMap(colNames);
        }
        String row = "";
        while ((row = csvReader.readLine()) != null) {
            String[] data = row.split(this.sep);
            this.addRecordToHashmap(data);
        }
        return this.content;
    }

    public void writeCSV(String pathToCsv, HashMap<String, ArrayList<Object>> data) throws IOException, IllegalArgumentException {
        int i;
        FileWriter csvWriter = new FileWriter(pathToCsv);
        Set<String> setOfString = data.keySet();
        String[] keyList = new String[setOfString.size()];
        int index = 0;
        for (String str : setOfString) {
            keyList[index++] = str;
        }
        int[] row_length = new int[keyList.length];
        for (int i2 = 0; i2 < keyList.length; ++i2) {
            row_length[i2] = data.get(keyList[i2]).size();
        }
        boolean flag = true;
        int base_length = row_length[0];
        for (i = 0; i < row_length.length; ++i) {
            boolean bl = flag = base_length == row_length[i] && flag;
            if (flag) continue;
            throw new IllegalArgumentException("Columns have different number of items. Please check the Hashmap being used");
        }
        for (i = 0; i < keyList.length; ++i) {
            csvWriter.append(keyList[i]);
            if (i == keyList.length - 1) {
                csvWriter.append("\n");
                continue;
            }
            csvWriter.append(",");
        }
        for (i = 0; i < base_length; ++i) {
            for (int j = 0; j < keyList.length; ++j) {
                csvWriter.append(data.get(keyList[j]).get(i).toString());
                if (j == keyList.length - 1) {
                    csvWriter.append("\n");
                    continue;
                }
                csvWriter.append(",");
            }
        }
        csvWriter.flush();
        csvWriter.close();
    }
}

